package com.elitesland.yst.lm.order.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.lm.order.Application;
import com.elitesland.yst.lm.order.rpc.param.YstDemoDTO;
import com.elitesland.yst.lm.order.rpc.param.query.YstDemoQueryDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * DEMO服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/29
 */
@FeignClient(name = Application.NAME, path = DemoRpcService.URI)
@Validated
public interface DemoRpcService {
    String URI = Application.URI_PREFIX + "/demo";

    /**
     * Say Hello
     *
     * @param username 用户名
     * @return hello
     */
    @GetMapping(value = "/hello")
    ApiResult<String> hello(@RequestParam(value = "username", defaultValue = "anonymous") String username);

    /**
     * 查询DEMO数据
     *
     * @param queryDTO 查询参数
     * @return 查询结果
     */
    @PostMapping(value = "/query")
    ApiResult<List<YstDemoDTO>> query(YstDemoQueryDTO queryDTO);
}
