package com.elitesland.yst.lm.order.rpc.param.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author zhengyue
 * @description: 车架时间信息
 * @date 2024/2/29 9:27
 */
@Data
@ApiModel(value = "LmVehicleNoTimeVO", description = "车架时间信息")
public class LmVehicleNoTimeDTO implements Serializable {
    private static final long serialVersionUID = -8437534292453150799L;

    /**
     * 车架号
     */
    @ApiModelProperty("车架号")
    private String vehicleNo;

    @ApiModelProperty("出库日期")
    private LocalDateTime docTime;

    @ApiModelProperty("生产时间")
    private LocalDateTime offlineTime;

    @ApiModelProperty("商品编码")
    private String itemCode;
}
