package com.elitesland.yst.lm.order.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.lm.order.Application;
import com.elitesland.yst.lm.order.rpc.param.query.CustOrderQueryDTO;
import com.elitesland.yst.lm.order.rpc.param.query.ItemQtyQueryDTO;
import com.elitesland.yst.lm.order.rpc.param.query.OrderAccQueryParam;
import com.elitesland.yst.lm.order.rpc.param.resp.ItemQtyRespDTO;
import com.elitesland.yst.lm.order.rpc.param.resp.LmSalSoSaveRespVO;
import com.elitesland.yst.lm.order.rpc.param.save.LmSalSoSaveDTO;
import com.elitesland.yst.lm.order.rpc.param.save.LmSalSoSaveRespDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 订单服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/29
 */
@FeignClient(name = Application.NAME, path = LmSalSoRpcService.URI)
@Validated
public interface LmSalSoRpcService {
    String URI = "/lm/salSoRpc";

    /**
     * 经销商商城下单-提交订单
     * @param param
     * @return
     */
    @PostMapping("/saveSo")
    ApiResult<List<LmSalSoSaveRespDTO>> saveSo(@RequestBody List<LmSalSoSaveDTO> param);

    /**
     * 经销商商城下单-提交订单
     * @param soIds
     * @return
     */
    @PostMapping("/revoteAndDelteSo")
    ApiResult revoteAndDelteSo(@RequestBody List<Long> soIds);

    @PostMapping("/queryItemQty")
    ApiResult<List<ItemQtyRespDTO>> queryItemQty(@RequestBody List<ItemQtyQueryDTO> param);

    @PostMapping("/queryCustItemQty")
    ApiResult<List<ItemQtyRespDTO>> queryCustItemQty(@RequestBody List<ItemQtyQueryDTO> param);

    /**
     * 查询未清数量-区分排产和现货
     * @param param
     * @return
     */
    @PostMapping("/queryCustItemQtyBySub")
    ApiResult<List<ItemQtyRespDTO>> queryCustItemQtyBySub(@RequestBody List<ItemQtyQueryDTO> param);

    /**
     * 查询未清数量-区分订单付款和未付款
     * @param param
     * @return
     */
    @PostMapping("/queryCustItemQtyByStatus")
    ApiResult<List<ItemQtyRespDTO>> queryCustItemQtyByStatus(@RequestBody List<ItemQtyQueryDTO> param);

    /**
     * 订单审核-补单价格校验
     * @param soId 订单id
     */
    @PostMapping("/verifySuppOrderPrice")
    ApiResult<Long> verifySuppOrderPrice(@RequestParam("soId") Long soId);

    /**
     * 整车订单提交校验
     * @param id
     * @return
     */
    @PostMapping("/submitCheck")
    ApiResult<LmSalSoSaveRespVO> submitCheck(@RequestParam("id") Long id);

    /**
     * 订单审核通过
     * @param ids
     * @return
     */
    @PostMapping("/approve")
    ApiResult<LmSalSoSaveRespVO> approve(@RequestBody List<Long> ids);

    @PostMapping("/getOwerCannelTime")
    LocalDateTime getOwerCannelTime();

    @PostMapping("/getSoDocNoByOu")
    List<String> getSoDocNoByOu(@RequestBody List<CustOrderQueryDTO> params);

    @PostMapping("/getSoDocNoByCustCode")
    List<String> getSoDocNoByCustCode(@RequestBody List<String> custCodes);

    @PostMapping("/getSoDocNoByAccCodes")
    List<String> getSoDocNoByAccCodes(@RequestBody List<String> accCodes);

    @PostMapping("/getSoDocNoByAccParams")
    List<String> getSoDocNoByAccParams(@RequestBody List<OrderAccQueryParam> params);
    @PostMapping("/getCountByCode")
    List<String> getCountByCode(@RequestParam("billtoCustCode") String billtoCustCode);
    @PostMapping("getPendingPayAmtByParams")
    ApiResult<BigDecimal> getPendingPayAmtByParam(@RequestParam("custId") Long custId,@RequestParam("invCode") String invCode);
}
