package com.elitesland.yst.lm.order.rpc.param.save;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "LmSalSoDSaveDTO", description = "销售订单明细表")
public class LmSalSoDSaveDTO implements Serializable {

    private static final long serialVersionUID = -1870545832225590318L;
    /**
     * 记录唯一ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    private String suppName;
    private String returnStatus;
    private String pickingStatus;
    /**
     * 主表ID
     */
    @ApiModelProperty("主表ID")
    private Long masId;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long ouId;

    @ApiModelProperty("备注")
    private String remark;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    private Long buId;
    /**
     * 事业部ID
     */
    @ApiModelProperty("事业部ID")
    private Long bdId;
    /**
     * 利润中心ID
     */
    @ApiModelProperty("利润中心ID")
    private Long pcId;
    /**
     * 行号
     */
    @ApiModelProperty("行号")
    private BigDecimal lineNo;
    /**
     * 行类型 [UDC]SAL:SO_LINE_TYPE/RSO_LINE_TYPE
     */
    @ApiModelProperty("行类型 [UDC]SAL:SO_LINE_TYPE/RSO_LINE_TYPE")
    private String lineType;
    private String lineTypeList;

    @ApiModelProperty("行类型 名称")
    private String lineTypeName;
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private LocalDateTime planServiceDate;

    /**
     * 行类型列表
     */
    @ApiModelProperty("行类型列表")
    private List<SalLinetypeDTO> salLinetypeRespVOS;
    /**
     * 行状态
     */
    @ApiModelProperty("行状态")
    private String lineStatus;

    @ApiModelProperty("配货类型ITM:ALLOC_TYPE")
    private String allocType;
    private String allocTypeName;
    @ApiModelProperty("服务工单策略 1=需要生成服务工单。0=不需要生成服务工单。生成服务工单时会用到这个值。")
    private String servicePolicy;
    @ApiModelProperty("价格策略 1=有价格。0=0价格。0价格的在创建和编辑订单时，价格不需要获取，直接就是0，且不能修改")
    private String pricePolicy;
    /**
     * 价格修订策略
     * 0不能改
     * 1能改
     */
    @ApiModelProperty("价格修订策略0不能改 1能改")
    private String  priceModifyPolicy;
    /**
     * 金额策略
     * 0=数量*单价
     * 1=自由填写
     */
    @ApiModelProperty("金额策略0=数量*单价,1=自由填写")
    private String  amtPolicy;

    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    private Long whId;
    /**
     * 收方仓库ID
     */
    @ApiModelProperty("收方仓库ID")
    private Long recvWhId;
    @ApiModelProperty("应支付金额")
    private BigDecimal apAmt;
    private BigDecimal payingAmt;
    @ApiModelProperty("已支付金额")
    private BigDecimal payedAmt;
    @ApiModelProperty("未结金额")
    private BigDecimal openAmt;
    /**
     * 收方限定1
     */
    @ApiModelProperty("收方限定1")
    private String recvDeter1;
    /**
     * 收方限定2
     */
    @ApiModelProperty("收方限定2")
    private String recvDeter2;
    /**
     * 收方限定3
     */
    @ApiModelProperty("收方限定3")
    private String recvDeter3;
    /**
     * 限定1
     */
    @ApiModelProperty("限定1")
    private String deter1;
    /**
     * 限定2
     */
    @ApiModelProperty("功能区")
    private String deter2;

    /**
     * 限定3
     */
    @ApiModelProperty("库存类型 排产:PL 现货:XH ")
    private String deter3;
    /**
     * 限定4
     */
    @ApiModelProperty("限定4")
    private String deter4;
    /**
     * 限定5
     */
    @ApiModelProperty("限定5")
    private String deter5;
    /**
     * 限定6
     */
    @ApiModelProperty("限定6")
    private String deter6;
    /**
     * 限定7
     */
    @ApiModelProperty("限定7")
    private String deter7;
    /**
     * 限定8
     */
    @ApiModelProperty("限定8")
    private String deter8;

    /**
     * 货位
     */
    @ApiModelProperty("货位")
    private String whPosi;
    /**
     * 客户ID
     */
    @ApiModelProperty("客户ID")
    private Long custId;
    /**
     * 商品ID
     */
    @ApiModelProperty("商品ID")
    private Long itemId;
    @ApiModelProperty("品牌")
    private   String itemBrand;
    private String brandName;
    private String deter2Name;
    @ApiModelProperty("批号")
    private String lotNo;
    @ApiModelProperty("承运商")
    private String carrier;
    private String cardType;
    private String cardStatus;
    private BigDecimal cardValue;

    /**
     * 商品编号
     */
    @ApiModelProperty("商品编号")
    private String itemCode;
    /**
     * 老物料编码
     */
    @ApiModelProperty("老物料编码")
    private String itemCodeHis;
    /**
     * 商品名称
     */
    @ApiModelProperty("商品名称")
    private String itemName;
    /**
     * 商品名称2
     */
    @ApiModelProperty("商品名称2")
    private String itemName2;
    /**
     * 商品规格
     */
    @ApiModelProperty("商品规格")
    private String itemSpec;

    /**
     * 客户商品编号
     */
    @ApiModelProperty("客户商品编号")
    private String itemCsCode;
    /**
     * SPUID
     */
    @ApiModelProperty("SPUID")
    private Long spuId;
    /**
     * SPU编号
     */
    @ApiModelProperty("SPU编号")
    private String spuCode;
    /**
     * SPU名称
     */
    @ApiModelProperty("SPU名称")
    private String spuName;
    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barcode;
    /**
     * 是否供应商代发
     */
    @ApiModelProperty("是否供应商代发")
    private String suppFlag;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    private Long suppId;
    /**
     * 是否需要服务
     */
    @ApiModelProperty("是否需要服务")
    private String needServiceFlag;
    /**
     * 是否安装收费
     */
    @ApiModelProperty("是否安装收费")
    private String serviceFeeFlag;
    /**
     * 运输方式 [UDC]COM:TP_TYPE
     */
    @ApiModelProperty("运输方式 [UDC]COM:TP_TYPE")
    private String transType;
    /**
     * 运输温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("运输温层 [UDC]INV:TEMP_TYPE")
    private String transportTemp;
    /**
     * 承运商供应商ID
     */
    @ApiModelProperty("承运商供应商ID")
    private Long carrierSuppId;

    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private BigDecimal qty;
    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String uom;
    private String uomName;
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    private String itemType;
    private String itemTypeName;

    /**
     * 单个毛重
     */
    @ApiModelProperty("单个毛重")
    private BigDecimal singleGrossWeight;
    /**
     * 数量2
     */
    @ApiModelProperty("数量2")
    private BigDecimal qty2;
    /**
     * 单位2
     */
    @ApiModelProperty("单位2")
    private String uom2;
    /**
     * 单位转换率
     */
    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;
    /**
     * 单位转换率2
     */
    @ApiModelProperty("单位转换率2")
    private BigDecimal uomRatio2;
    /**
     * 装箱要求 [UDC]COM:PACK_DEMAND
     */
    @ApiModelProperty("装箱要求 [UDC]COM:PACK_DEMAND")
    private String packDemand;
    /**
     * 包装数量
     */
    @ApiModelProperty("包装数量")
    private BigDecimal packQty;
    /**
     * 包装单位
     */
    @ApiModelProperty("包装单位")
    private String packUom;
    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;


    /**
     * 总重量
     */
    @ApiModelProperty("总重量")
    private BigDecimal grossWeight;
    /**
     * 暂挂数量
     */
    @ApiModelProperty("暂挂数量")
    private BigDecimal holdQty;

    @ApiModelProperty("暂挂原因")
    private String holdReasonCode;




    @ApiModelProperty("取消原因")
    private String cancelReason;
    /**
     * 重量单位
     */
    @ApiModelProperty("重量单位")
    private String weightUom;
    /**
     * 重量转换率 重量单位与主单位
     */
    @ApiModelProperty("重量转换率 重量单位与主单位")
    private BigDecimal weightRatio;
    private String weightUomName;
    private String volumeUomName;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;
    /**
     * 单位体积
     */
    @ApiModelProperty("单位体积")
    private BigDecimal singleVolume;
    /**
     * 体积单位
     */
    @ApiModelProperty("体积单位")
    private String volumeUom;
    /**
     * 基价
     */
    @ApiModelProperty("基价")
    private BigDecimal basePrice;
    /**
     * 价格类型
     */
    @ApiModelProperty("价格类型")
    private String priceType;
    /**
     * 含税价格 合同价
     */
    @ApiModelProperty("含税价格 合同价")
    private BigDecimal price;
    /**
     * 不含税价格 合同价
     */
    @ApiModelProperty("不含税价格 合同价")
    private BigDecimal netPrice;
    /**
     * 客户含税价格
     */
    @ApiModelProperty("客户含税价格")
    private BigDecimal refTaxPrice;
    /**
     * 折扣类型
     */
    @ApiModelProperty("折扣类型")
    private String discType;
    /**
     * 折扣率
     */
    @ApiModelProperty("折扣率")
    private BigDecimal discRatio;
    /**
     * 折扣未税额
     */
    @ApiModelProperty("折扣未税额")
    private BigDecimal discNetAmt;
    /**
     * 折扣含税额
     */
    @ApiModelProperty("折扣含税额")
    private BigDecimal discAmt;
    /**
     * 折扣描述
     */
    @ApiModelProperty("折扣描述")
    private String discDesc;
    /**
     * 客户未税价格
     */
    @ApiModelProperty("客户未税价格")
    private BigDecimal refPrice;
    /**
     * 交易未税单价 折扣后
     */
    @ApiModelProperty("交易未税单价 折扣后")
    private BigDecimal transNetPrice;
    /**
     * 交易含税单价 折扣后
     */
    @ApiModelProperty("交易含税单价 折扣后")
    private BigDecimal transPrice;

    /**
     * 支付状态
     */
    @ApiModelProperty("支付状态")
    private String payStatus;
    /**
     * 发票状态
     */
    @ApiModelProperty("发票状态")
    private String invStatus;
    /**
     * 发票日期
     */
    @ApiModelProperty("发票日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private LocalDateTime invDate;
    /**
     * 客户税类型
     */
    @ApiModelProperty("客户税类型")
    private String custTaxType;
    /**
     * 商品税类型
     */
    @ApiModelProperty("商品税类型")
    private String itemTaxType;
    /**
     * 税码
     */
    @ApiModelProperty("税码")
    private String taxCode;
    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;
    /**
     * 税率
     */
    @ApiModelProperty("税率")
    private BigDecimal taxRate;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 未税原金额
     */
    @ApiModelProperty("未税原金额")
    private BigDecimal orignNetAmt;
    /**
     * 含税原金额
     */
    @ApiModelProperty("含税原金额")
    private BigDecimal orignAmt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 本币币种
     */
    @ApiModelProperty("本币币种")
    private String homeCurr;
    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private BigDecimal currRate;
    /**
     * 允收期编码
     */
    @ApiModelProperty("允收期编码")
    private String aapCode;
    /**
     * 要求保质期比例
     */
    @ApiModelProperty("要求保质期比例")
    private BigDecimal demandFreshPercent;
    /**
     * 最低允收期天数
     */
    @ApiModelProperty("最低允收期天数")
    private Long demandAapDays;
    /**
     * 配货数量
     */
    @ApiModelProperty("配货数量")
    private BigDecimal allocQty;
    /**
     * 配货状态 [UDC]SAL:SO_ALLOC_STATUS
     */
    @ApiModelProperty("配货状态 [UDC]SAL:SO_ALLOC_STATUS")
    private String allocStatus;
    /**
     * 物流状态
     */
    @ApiModelProperty("物流状态 物流状态 [UDC]SAL:SO_LOGIS_STATUS")
    private String logisStatus;

    @ApiModelProperty("签收状态 SAL SO_CONFIRM_STATUS")
    private String confirmStatus;

    /**
     * 要求日期
     */
    @ApiModelProperty("要求交货日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private LocalDateTime demandDate;
    /**
     * 计划出库日期
     */
    @ApiModelProperty("计划出库日期")
    private String planShipDate;
    private String itemCateCode;
    /**
     * 承诺交货日期
     */
    @ApiModelProperty("承诺交货日期")
    private String promiseDeliverDate;
    /**
     * 通知仓库发货时间
     */
    @ApiModelProperty("通知仓库发货时间")
    private String commandShipTime;
    /**
     * 拣货时间
     */
    @ApiModelProperty("拣货时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private LocalDateTime pickTime;
    /**
     * 出库确认时间
     */
    @ApiModelProperty("出库确认时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private LocalDateTime shipConfirmTime;
    /**
     * 发货未税金额
     */
    @ApiModelProperty("发货未税金额")
    private BigDecimal shippedNetAtm;

    /**
     * 暂挂时间
     */
    @ApiModelProperty("暂挂时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private LocalDateTime holdTime;
    /**
     * 暂挂描述
     */
    @ApiModelProperty("暂挂描述")
    private String holdReasonDesc;
    /**
     * 暂挂用户ID
     */
    @ApiModelProperty("暂挂用户ID")
    private Long holdUserId;
    /**
     * 退货原因码 [UDC]SAL:SO_RETURN_REASON
     */
    @ApiModelProperty("退货原因码 [UDC]SAL:SO_RETURN_REASON")
    private String returnReasonCode;
    /**
     * 是否实物退回
     */
    @ApiModelProperty("是否实物退回")
    private String returnMatFlag;
    /**
     * 已退货数量
     */
    @ApiModelProperty("已退货数量")
    private BigDecimal returnedQty;
    /**
     * 已取消数量
     */
    @ApiModelProperty("已取消数量")
    private BigDecimal cancelQty;
    /**
     * 已取消含税金额
     */
    @ApiModelProperty("已取消含税金额")
    private BigDecimal cancelAtm;
    /**
     * 取消时间
     */
    @ApiModelProperty("取消时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd")
    private LocalDateTime cancelTime;

    /**
     * 取消用户ID
     */
    @ApiModelProperty("取消用户ID")
    private Long cancelUserId;
    /**
     * 已退货含税金额
     */
    @ApiModelProperty("已退货含税金额")
    private BigDecimal returnedAtm;
    /**
     * 已退货未税金额
     */
    @ApiModelProperty("已退货未税金额")
    private BigDecimal returnedNetAtm;
    /**
     * 已出库数量
     */
    @ApiModelProperty("已出库数量")
    private BigDecimal shippedQty;
    /**
     /**
     * 已签收数量
     */
    @ApiModelProperty("已签收数量")
    private BigDecimal confirmQty;
    /**
     * 硬承诺数量
     */
    @ApiModelProperty("硬承诺数量")
    private BigDecimal hardPromiseQty;
    /**
     * 已取消未税金额
     */
    @ApiModelProperty("已取消未税金额")
    private BigDecimal cancelNetAtm;
    /**
     * 拣货数量
     */
    @ApiModelProperty("拣货数量")
    private BigDecimal pickedQty;
    /**
     * 促销ID 大昌行暂不启用
     */
    @ApiModelProperty("促销ID 大昌行暂不启用")
    private Long promId;
    /**
     * 促销编号 大昌行暂不启用
     */
    @ApiModelProperty("促销编号 大昌行暂不启用")
    private String promNo;
    private String  whCode;
    private String  whType;
    private String whName;
    /**
     * 最后出库批次 针对这家客户的
     */
    @ApiModelProperty("最后出库批次 针对这家客户的")
    private LocalDateTime lastOutLot;
    /**
     * 发货含税金额
     */
    @ApiModelProperty("发货含税金额")
    private BigDecimal shippedAtm;
    /**
     * 根ID
     */
    @ApiModelProperty("根ID")
    private Long rootId;
    /**
     * 关联单据类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联单据明细ID
     */
    @ApiModelProperty("关联单据明细ID")
    private Long relateDocDid;
    /**
     * 关联单据行号
     */
    @ApiModelProperty("关联单据行号")
    private BigDecimal relateDocLineno;
    /**
     * 关联单据2类别 [UDC]COM:DOC_CLS
     */
    @ApiModelProperty("关联单据2类别 [UDC]COM:DOC_CLS")
    private String relateDoc2Cls;
    /**
     * 关联单据2类型
     */
    @ApiModelProperty("关联单据2类型")
    private String relateDoc2Type;
    /**
     * 关联单据2ID
     */
    @ApiModelProperty("关联单据2ID")
    private Long relateDoc2Id;
    /**
     * 关联单据2编号
     */
    @ApiModelProperty("关联单据2编号")
    private String relateDoc2No;
    /**
     * 关联单据2明细ID
     */
    @ApiModelProperty("关联单据2明细ID")
    private Long relateDoc2Did;
    /**
     * 关联单据2行号
     */
    @ApiModelProperty("关联单据2行号")
    private BigDecimal relateDoc2Lineno;
    /**
     * 外部单据公司
     */
    @ApiModelProperty("外部单据公司")
    private String outerOu;
    /**
     * 外部单据类型
     */
    @ApiModelProperty("外部单据类型")
    private String outerType;
    /**
     * 外部单据编号
     */
    @ApiModelProperty("外部单据编号")
    private String outerNo;
    /**
     * 外部单据行号
     */
    @ApiModelProperty("外部单据行号")
    private String outerLineno;


    @ApiModelProperty("制造商ID")
    private Long manuerId;

    @ApiModelProperty("制造商名称")
    private String manuerName;

    @ApiModelProperty("待开票金额")
    private BigDecimal noinvAmt;

    @ApiModelProperty("已开票金额")
    private BigDecimal invedAmt;
    @ApiModelProperty("已开票数量")
    private BigDecimal invedQty;

    @ApiModelProperty("排期类型")
    private String scheduleType;

    private Long createUserId;
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;
    private Long modifyUserId;
    @DateTimeFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modifyTime;



    @ApiModelProperty("来源单据明细ID ")
    private Long rootDocDId;

    @ApiModelProperty("来源单据行号 ")
    private Long rootDocLineno;

    /**
     * 关联单据类别 来源采购订单等。[UDC]COM:DOC_CLS
     */
    @ApiModelProperty("来源单据类别 ")
    private String rootDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("来源单据类型")
    private String rootDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    private Long rootDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String rootDocNo;
    /**
     * 批准退款金额
     */
    @ApiModelProperty("批准退款金额")
    private BigDecimal refundAmt;
    /**
     * 实际退货金额
     */
    @ApiModelProperty("实际退货金额")
    private BigDecimal confirmAmt;

    @ApiModelProperty("拒收数量")
    private BigDecimal rejectQty;
    @ApiModelProperty("出货方式")
    private String sellMethod;
    @ApiModelProperty("行标记 区分主件/子件")
    private String lineFlag;

    @ApiModelProperty("主件id")
    private Long pid;

    @ApiModelProperty("主件行号")
    private BigDecimal pNo;

    @ApiModelProperty("子件商品明细")
    private List<LmSalSoDSaveDTO> salSoDSubPartVOList;

    @ApiModelProperty("附件商品列表")
    private List<LmSalSoDSaveDTO> salSoDAccessoryVOList;


    @ApiModelProperty("发运基地Id")
    private Long desId;

    @ApiModelProperty("商品数量")
    private BigDecimal LockQty;

    private String itemCode2;

    private String itemCode3;

    private String itemName3;

    private String itemAbbr;

    private String itemType2;

    private String itemType3;

    private String itemType4;

    private String itemType5;

    private String itemGroup;

    private String itemGroup2;

    private String itemGroup3;

    private String origin;

    @ApiModelProperty("退货审核数量")
    private BigDecimal returnApprQty;

    @ApiModelProperty("退货审核金额")
    private BigDecimal returnApprAmt;

    @ApiModelProperty("退货开票金额")
    private BigDecimal returninvAmt;

    @ApiModelProperty("全国统一价")
    private BigDecimal unifyPrice;

    @ApiModelProperty("商品属性")
    private String attr;
    @ApiModelProperty("库存客户编码")
    private String invCustCode;

    @ApiModelProperty("库存客户名称")
    private String invCustName;
    @ApiModelProperty("配件比例")
    private BigDecimal partRate;

    @ApiModelProperty("赠品类型")
    private String giftType;

    @ApiModelProperty("赠品来源行号")
    private BigDecimal giftRelateNo;

    private Long relateDid;

    @ApiModelProperty("加价率")
    private BigDecimal addRate = BigDecimal.ONE;

    @ApiModelProperty("综合价")
    private BigDecimal totalPrice;

    @ApiModelProperty("颜色")
    private String color;

    @ApiModelProperty(value = "整车定位")
    private String itemPosit;
    @ApiModelProperty("收货客户类型")
    private String recvCustType;
    @ApiModelProperty("客户号")
    private String custNo;
    private String shippingMethod;
    private String cat3;
    @ApiModelProperty("销售商品编码")
    private String saleItemCode;

    @ApiModelProperty("收货仓库编码")
    private String recvWhCode;

    @ApiModelProperty("收货仓库名称")
    private String recvWhName;

    private String custCode;
    private String custCode2;

    private String custName;
    @ApiModelProperty("是否启用批次 0-未启用 1-启用")
    private Integer lotFlag1;
    @ApiModelProperty("库存客户号")
    private String invCustCode2;
    @ApiModelProperty("订单明细价格表")
    List<LmPriceRpcDTO> priPriceRpcDTOList;

    @ApiModelProperty("门店名称")
    private String storeName;

    @ApiModelProperty("门店编码")
    private String storeCode;

    @ApiModelProperty("门店编码2")
    private String storeCode2;

    @ApiModelProperty("门店地址")
    private String address;
}
