package com.elitesland.tw.tw5.api.bpm.common.dto;

import com.elitescloud.cloudt.system.vo.SysUserDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * bpm用户dto
 *
 * @author duwh
 * @date 2024/04/10
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BpmUserDTO implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 用户ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 用户名
     */
    private String userName;

    /**
     * 电子邮件
     */
    private String email;

    /**
     * 可移动
     */
    private String mobile;

    /**
     * 用户编号
     */
    private String userNo;

    /**
     * 用户账号
     */
    private String userLogin;

    /**
     * 属于组织id
     */
    private Long orgId;

    /**
     * 属于组织名称
     */
    private String orgName;

    /**
     * 上级员工ID
     */
    private Long parentId;

    /**
     * 上级员工名称
     */
    private String parentName;

    /**
     * sys用户 3.2.58 架构版本
     */
    private SysUserDTO sysUser;
    /**
     * sys用户公用  兼容各个版本 需要单独赋值
     */
    private SysUserCommonDTO sysUserCommon;


}
