package com.elitesland.tw.tw5.api.bpm.common.dto;

import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Set;


/**
 * sys用户通用dto
 *
 * @author duwh
 * @date 2024/04/10
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysUserCommonDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 用户ID
     */
    @ApiModelProperty("记录唯一ID")
    private Long id;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    private Long tenantId;

    /**
     * 所属公司ID
     */
    private Long ouId;

    /**
     * 公司编码
     */
    private String ouCode;

    /**
     * 公司名称
     */
    private String ouName;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("记录创建者ID")
    private Long createUserId;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "用户账号名称")
    private String username;

    @ApiModelProperty(value = "用户姓氏")
    private String lastName;

    @ApiModelProperty(value = "用户名称")
    private String firstName;

    @ApiModelProperty(value = "用户手机号码")
    private String mobile;

    @ApiModelProperty(value = "用户邮箱地址")
    private String email;

    @ApiModelProperty(value = "用户账号密码-hashed")
    private String password;

    @ApiModelProperty(value = "微信openid")
    private String wxOpenid;

    /**
     * {@link UserSourceType}
     */
    @ApiModelProperty("账号来源")
    private String sourceType;

    @ApiModelProperty(value = "是否启用")
    private Boolean enabled;

    @ApiModelProperty(value = "是否需要重置")
    private Boolean needReset;

    /**
     * 账号过期时间
     */
    private LocalDateTime expiredTime;

    /**
     * 角色编码
     */
    private Set<String> roleCodes = Collections.emptySet();

    /**
     * 角色ID
     */
    private Set<Long> roleIds = Collections.emptySet();

    /**
     * 用户头像地址
     */
    private String avatarUrl;

    /**
     * 用户头像的文件编码
     */
    private String avatarCode;

    /**
     * 用户的终端
     */
    private List<Terminal> terminals = Collections.emptyList();

    /**
     * 用户所有的租户
     */
    private List<SysTenantDTO> sysTenantDTOList = Collections.emptyList();

    /**
     * 用户当前的租户
     */
    private SysTenantDTO sysTenantVO;

    /**
     * 所在组织的列表
     */
    private List<SysOrgBasicDTO> orgList;

    /**
     * 当前组织
     */
    private SysOrgBasicDTO org;

    /**
     * 所属租户组织
     */
    private SysOrgBasicDTO tenantOrg;

    /**
     * 租户组织管理员ID
     */
    private Long tenantOrgAdminId;

    public Long getTenantId() {
        if (sysTenantVO != null) {
            return sysTenantVO.getId();
        }
        return tenantId;
    }

    /**
     * 获取姓名
     *
     * @return 姓名
     */
    public String getPrettyName() {
        StringBuilder result = new StringBuilder();
        if (getLastName() != null) {
            result.append(getLastName());
        }
        if (getFirstName() != null) {
            result.append(getFirstName());
        }

        return result.toString();
    }
}
