package com.elitesland.tw.tw5.api.bpm.common.payload;

import com.elitesland.tw.tw5.api.bpm.common.constants.BpmSystemCodeEnum;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * bpm有效载荷
 * {
 * "sourceSystemCode": "YEEDOC",
 * "targetSystemCode": "WEAVER_E9",
 * "data": {
 * "user": "7402",
 * "bu": "588",
 * "buName": "部门",
 * "applyDate": "2024-04-08",
 * "startDate": "2024-04-08",
 * "endDate": "2024-04-08",
 * "num": "1",
 * "reason": "TEST埃林哲测试请假流程原由",
 * "tel": "18888888888",
 * "startTime": "14:30",
 * "endTime": "14:30",
 * "desc": "TEST埃林哲测试请假流程原由111",
 * "daili": "7402",
 * "type": "25"
 * },
 * "userid": "7402",
 * "wfCode": "A01"
 * }
 *
 * @author duwh
 * @date 2024/04/09
 */
@Data
public class BpmPayload {

    /**
     * 共享人员关系
     */
    private Boolean sharedPersonnelRelation;

    /**
     * 系统编码 示例 YEEDOC
     */
    @NotNull
    private String sourceSystemCode;

    /**
     * 系统编码 示例 WEAVER_E9
     */
    @NotNull
    private String targetSystemCode;

    /**
     * 业务数据
     */
    private Map<String, Object> data;

    /**
     * 明细行数据
     */
//    private Map<String, Map<String, Object>> detailData;
    private Map<String, List<Map<String, Object>>> detailData;

    /**
     * 流程发起人Id
     */
    @NotNull
    private String userid;

    private String objType;

    private String objId;

    /**
     * 通用BPM流程编码 示例 A01
     */
    private String wfCode;

    /**
     * 审批意见
     */
    private String comment;

    /**
     * 流程实例名称 通用
     */
    private String procInstName;

    /**
     * 流程Id 通用 有值代表再次提交
     */
    private String procInstId;
    /**
     * 业务主键 for EL
     */
    @NotNull
    private String businessKey;
    /**
     * 流程变量 for EL
     */
    private HashMap<String, Object> variables;

    public BpmPayload() {

    }

    public BpmPayload ofWeaverE9(BpmSystemCodeEnum sourceSystemCode, BpmSystemCodeEnum targetSystemCode, Map<String, Object> data, String userid, String wfCode, String procInstName) {
        BpmPayload bpmPayload = new BpmPayload();
        bpmPayload.setSourceSystemCode(sourceSystemCode.getCode());
        bpmPayload.setTargetSystemCode(targetSystemCode.getCode());
        bpmPayload.setData(data);
        bpmPayload.setUserid(userid);
        bpmPayload.setWfCode(wfCode);
        bpmPayload.setProcInstName(procInstName);
        return bpmPayload;
    }

    /**
     * el工作流
     *
     * @param sourceSystemCode 业务系统代码
     * @param targetSystemCode 目标系统代码
     * @param data             业务数据
     * @param userid           userid
     * @param wfCode           工作流代码
     * @param procInstName     流程名称
     * @param businessKey      业务主键
     * @param variables        流程变量
     * @return {@link BpmPayload}
     */
    public BpmPayload ofEl(BpmSystemCodeEnum sourceSystemCode, BpmSystemCodeEnum targetSystemCode,
                           Map<String, Object> data, String userid,
                           String wfCode, String procInstName,
                           String businessKey, HashMap<String, Object> variables) {
        BpmPayload bpmPayload = new BpmPayload();
        bpmPayload.setSourceSystemCode(sourceSystemCode.getCode());
        bpmPayload.setTargetSystemCode(targetSystemCode.getCode());
        bpmPayload.setData(data);
        bpmPayload.setUserid(userid);
        bpmPayload.setWfCode(wfCode);
        bpmPayload.setProcInstName(procInstName);
        bpmPayload.setBusinessKey(businessKey);
        bpmPayload.setVariables(variables);
        return bpmPayload;
    }

    /**
     * el工作流 simple
     *
     * @param sourceSystemCode 业务系统代码
     * @param targetSystemCode 目标系统代码
     * @param wfCode           工作流代码
     * @param procInstName     流程名称
     * @param businessKey      业务主键
     * @param variables        流程变量
     * @return {@link BpmPayload}
     */
    public BpmPayload ofElSimple(BpmSystemCodeEnum sourceSystemCode, BpmSystemCodeEnum targetSystemCode, String wfCode, String procInstName, String businessKey, HashMap<String, Object> variables) {
        BpmPayload bpmPayload = new BpmPayload();
        bpmPayload.setSourceSystemCode(sourceSystemCode.getCode());
        bpmPayload.setTargetSystemCode(targetSystemCode.getCode());
        bpmPayload.setWfCode(wfCode);
        bpmPayload.setProcInstName(procInstName);
        bpmPayload.setBusinessKey(businessKey);
        bpmPayload.setVariables(variables);
        return bpmPayload;
    }

}
