package com.elitesland.tw.tw5.api.bpm.weavere9.callback.payload;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

/**
 * 泛微OA流程回调 请求参数
 * <p>
 * （流程编号 每个流程不同，需要回调接口写死）、流程id、userid   流程状态  流程节点  所有业务单据
 *
 * @author duwh
 * @date 2024/04/15
 */
@Data
public class TaskAssigneeE9Payload {

    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 流程编号 示例数据 ZHIYUANPUFI_PUR_SUPP_SUB_APPLY
     */
    @ApiModelProperty(required = true)
    private String procDefKey;

    /**
     * 业务流程编号 示例 PUR_SUPP_SUB_APPLY
     */
    @ApiModelProperty(required = true)
    private String procDefKeyBussiness;

    /**
     * 工作流id 示例 16522
     */
    private String workflowId;
    /**
     * 用户id
     */
    private String userId;

    /**
     * 业务主键
     */
    @ApiModelProperty(required = true)
    private String businessKey;
    /**
     * 工作流状态 com.elitesland.workflow.enums.ProcInstStatus
     *
     * NOTSUBMIT("未提交"),
     * APPROVING("审批中"),
     * APPROVED("审批通过"),
     * REJECTED("审批拒绝"),
     * DISAGREE("不同意"),
     * INVALID("作废"),
     * INTERRUPT("中断执行"),
     * DELETE("删除"),
     */
    @ApiModelProperty(required = true)
    private String workflowStatus;
    /**
     * 工作流节点
     */
    private String workflowNode;

    /**
     * 审批人用户id
     */
    private String apprUserId;
    /**
     * 审批人用户名称
     */
    private String apprUserName;
    /**
     * 审批意见
     */
    private String comment;

    /**
     * 数据
     */
    private Map<String, Object> data;

    private String customParams;
    private String customParams2;
    private Map<String, Object> customParamsMap;


}
