/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.api.bpm.common.util;

import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecConverterUtil {
    private static final Logger log = LoggerFactory.getLogger(SpecConverterUtil.class);

    public static void convertSpecFieldsToString(Object sourceObj, Map<String, Object> targetMap) {
        if (sourceObj == null || targetMap == null) {
            return;
        }
        for (Class<?> clazz = sourceObj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                SpecConverterUtil.processSpecField(sourceObj, targetMap, field);
            }
        }
    }

    private static void processSpecField(Object sourceObj, Map<String, Object> targetMap, Field field) {
        Object value;
        if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            try {
                field.setAccessible(true);
                value = field.get(sourceObj);
                if (value != null) {
                    targetMap.put(field.getName(), (Boolean)value != false ? "\u662f" : "\u5426");
                }
            }
            catch (IllegalAccessException e) {
                log.error("processSpecField\u5904\u7406\u5f02\u5e38", (Throwable)e);
            }
        }
        if (field.getType().equals(LocalDateTime.class)) {
            try {
                field.setAccessible(true);
                value = field.get(sourceObj);
                if (value != null) {
                    targetMap.put(field.getName(), ((LocalDateTime)value).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                }
            }
            catch (IllegalAccessException e) {
                log.error("processSpecField\u5904\u7406\u5f02\u5e38", (Throwable)e);
            }
        }
    }
}

