/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.api.common.util;

import com.elitesland.tw.tw5.api.common.util.TreeInterface;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TreeListUtil {
    public static <E extends TreeInterface<E>> void treeListForEach(List<E> list, Consumer<E> action) {
        Objects.requireNonNull(action);
        if (list == null || list.size() == 0) {
            return;
        }
        list.forEach(data -> {
            action.accept(data);
            if (data.getChildren() != null) {
                TreeListUtil.treeListForEach(data.getChildren(), action);
            }
        });
    }

    public static <E extends TreeInterface<E>> void treeListForEach(List<E> list, BiConsumer<E, Integer> action, int initialLevel) {
        Objects.requireNonNull(action);
        if (list == null || list.size() == 0) {
            return;
        }
        list.forEach(data -> {
            action.accept(data, initialLevel);
            if (data.getChildren() != null) {
                TreeListUtil.treeListForEach(data.getChildren(), action, initialLevel + 1);
            }
        });
    }

    public static <E extends TreeInterface<E>> List<E> toTree(List<E> list) {
        if (list == null || list.size() == 0) {
            return list;
        }
        try {
            TreeInterface root = (TreeInterface)((TreeInterface)list.get(0)).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map map = list.stream().collect(Collectors.toMap(TreeInterface::getCode, Function.identity(), (entity1, entity2) -> entity1));
            list.forEach(view -> map.getOrDefault(view.getParentCode(), root).addChildren(view));
            return root.getChildren();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static <E extends TreeInterface<E>> void treeListForEachAfter(List<E> list, Consumer<E> action) {
        Objects.requireNonNull(action);
        if (list == null || list.size() == 0) {
            return;
        }
        list.forEach(data -> {
            if (data.getChildren() != null) {
                TreeListUtil.treeListForEachAfter(data.getChildren(), action);
            }
            action.accept(data);
        });
    }

    public static <E extends TreeInterface<E>> List<E> treeToList(List<E> list) {
        ArrayList returnList = new ArrayList();
        TreeListUtil.treeListForEachAfter(list, returnList::add);
        return returnList;
    }
}

