package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;

import java.util.List;

/**
* 客户经营-工商股东（含历史）
*
* @author duwh
* @date 2022-12-06
*/
@Data
public class CrmCustomerOperationPartnersQuery extends TwQueryParam{
    /** 精确 */
    @Query
    private Long operId;
    /** 精确 */
    @Query
    private String isHstory;
    /** 精确 */
    @Query
    private String stockType;
    /** 模糊 */
    @Query(type = Query.Type.INNER_LIKE)
    private String name;
    /** 精确 */
    @Query
    private String pid;
    /** 精确 */
    @Query
    private String eid;
    /** 精确 */
    @Query
    private String identifyType;
    /** 精确 */
    @Query
    private String identifyNo;
    /** 精确 */
    @Query
    private String type;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<String> totalRealCapi;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<String> date;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<String> totalShouldCapi;
    /** BETWEEN */
    @Query(type = Query.Type.BETWEEN)
    private List<String> capi;
}
