package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author zoey
 * @Description:线索表
 * @date 2022/5/17 - 11:38
 */
@Data
public class CrmLeadsQuery extends TwQueryParam {

    /**
     * 近海id
     */
    private List<Long> offshoreIds;

    /**
     * 线索主键 跟进时间筛选
     */
    private List<Long> leadsIdsForFollow;

    /**
     * 近海id
     */
    private Long offshoreId;

    /**
     * 线索阶段
     */
    private String leadsStageNotEqual;

    /**
     * 线索阶段
     */
    private List<String> leadsStageNotIn;

    /**
     * 线索阶段
     */
    private List<String> leadsStageIn;

    /**
     * 线索状态
     */
    private List<String> leadsStatusNotIn;


    /**
     * 线索编号
     */
    private String leadsNo;

    /**
     * 线索名称
     */
    private String leadsName;

    /**
     * 线索状态
     */
    private String leadsStatus;

    /**
     * 线索阶段
     */
    private String leadsStage;

    /**
     * 来源类型
     */
    private String sourceType;

    /**
     * 市场活动项目id
     */
    private Long marketId;

    /**
     * 市场渠道
     */
    private String marketChannel;

    /**
     * 渠道
     */
    private String channel;

    /**
     * 销售负责人id
     */
    private Long saleUserId;
    private List<Long> saleUserIds;

    private List<Long> ids;

    /**
     * 奖金分配类型
     */
    private String bonusDistributeType;

    /**
     * 奖金分配对象
     */
    private Long bonusDistributeTo;

    /**
     * 关闭原因
     */
    private String closeReason;
    /**
     * 需求产品
     */
    private String demandProduct;

    /**
     * 需求产品部门
     */
    private Long demandProductOrg;

    /**
     * 退回原因
     */
    private String backReason;

    /**
     * 收回原因
     */
    private String withdrawReason;

    /**
     * 转移原因
     */
    private String transferReason;

    /**
     * 分配日期
     */
    private LocalDate distributeDate;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    /**
     *创建时间(报备时间)*/
    private LocalDateTime createTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    /**
     *创建时间区间开始*/
    private LocalDateTime createTimeStart;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    /**
     *创建时间区间结束*/
    private LocalDateTime createTimeEnd;
    //客户表
    /**
     * 客户名称
     */
    private String customerName;
    private String customerNameEqual;

    /**
     * 客户行业
     */
    private String customerIndustry;

    /**
     * 客户级别
     */
    private String customerGrade;


    /**
     * 客户区域
     */
    private String custRegion;


    /**
     * 联系人电话
     */
    private String contactsPhone;

    /**
     * 来源人
     */
    private Long sourceUserId;


    private Long saleOrCreateUserId;

    /**
     * 模板：model 数据：data
     */
    private String downloadType;

    /**
     * 未跟进提醒时间
     */
    private Boolean notFollowLeadsRemindTimeNotNull;

    /**
     * 关联正式客户id
     */
    private Long formalCustomerId;
    /**
     * 是否需要权限判断
     */
    private Boolean isPermission = true;

    /**
     * 业务伙伴主键 business_partner.id
     */
    private Long partnerId;

    //----- 跟进

    /**
     * 跟进时间  创建时间区间开始
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime followCreateTimeStart;

    /**
     * 跟进时间  创建时间区间结束
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime followCreateTimeEnd;

    /**
     * 来源人id集合
     * 销售统计需要
     *
     */
    private List<Long> sourceUserIds;
}
