package com.elitesland.tw.tw5.api.prd.crm.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.change.vo.PrdSystemBusinessChangeVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActPlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActPlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActPlanVO;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;


/**
 * @author carl.wang
 * @Description:市场计划管理
 */
public interface CrmActPlanService {

    /**
     * @param payload
     * @Description 新增计划
     **/
    CrmActPlanVO insert(CrmActPlanPayload payload);

    /**
     * @param payload
     * @Description 修改计划
     **/
    Long update(CrmActPlanPayload payload);

    /**
     * @param key 主键id
     * @return boolean
     * @Description 逻辑删除
     **/
    boolean deleteSoft(Long key);

    /**
     * @param query
     * @return
     * @Description 分页查询
     **/
    PagingVO<CrmActPlanVO> paging(CrmActPlanQuery query);

    /**
     * 批量导出计划excel
     *
     * @param response 请求响应
     * @param query    查询条件
     */
    void downloadPlans(HttpServletResponse response, CrmActPlanQuery query);

    /**
     * 批量导出计划详情excel
     *
     * @param response 请求响应
     * @param planId   市場计划id
     */
    void downloadPlanDetails(HttpServletResponse response, Long planId);

    /**
     * @param newDate 开始时间
     * @return
     * @Description 查询本年度所有的市场计划
     **/
    List<CrmActPlanVO> queryPlans(LocalDateTime newDate);

    /**
     * @param key 主键
     * @return
     * @Description 主键查询
     **/
    CrmActPlanVO queryByKey(Long key);

    /**
     * @param key 主键
     * @return
     * @Description 提交审核
     **/
    boolean submitCheck(Long key);

    /**
     * @param key       主键
     * @param closeType 关闭原因
     * @return boolean
     * @Description 计划关闭
     **/
    boolean closePlan(Long key, String closeType);

    /**
     * @param payload
     * @return
     * @Description 新增计划明细
     **/
    CrmActPlanDetailVO insertDetail(CrmActPlanDetailPayload payload);

    /**
     * @param payload
     * @Description 修改计划明细
     **/
    Long updateDetail(CrmActPlanDetailPayload payload);

    /**
     * @param planId 市場计划id
     * @param key    市場计划详情主键id
     * @return boolean
     * @Description 逻辑删除
     **/
    boolean deleteDetailSoft(Long planId, Long key,Long changeLogId);

    /**
     * @param planId  活动计划id
     * @param newDate 活动开始时间
     * @return
     * @Description 活动计划明细查询
     **/
    List<CrmActPlanDetailVO> queryDetails(Long planId, LocalDateTime newDate);

    /**
     * @param
     * @return
     * @Description 取所有工种类型
     **/
    Map<String, Map<String, Map<String, BigDecimal>>> queryWorkTypes();


    /**
     * 变更历史列表
     * @param planId
     * @return
     */
    List<PrdSystemBusinessChangeVO> changeLogList(Long planId);



    /**
     * 当前计划下的当前版本的changeLog数据
     * @param planId
     * @return
     */
    Map<String,Object> changeLogDetailByPlanId(Long planId);

//    Map<String, Object> findChangeDataById(Long id);
//
//    List<Map<String, Object>> findDetailsChangeDataById(Long id,LocalDateTime newDate);
}

