package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationChancePayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationChanceQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationChanceVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;

import java.util.List;

/**
 * 人脉经营-经营机会点
 *
 * @author carl
 * @date 2022/11/21
 */
public interface CrmCustomerOperationChanceService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmCustomerOperationChanceVO}
     */
    CrmCustomerOperationChanceVO insertOrUpdate(CrmCustomerOperationChancePayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    CrmCustomerOperationChanceVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @return {@link List}<{@link CrmCustomerOperationChanceVO}>
     */
    List<CrmCustomerOperationChanceVO> queryList(Long operId);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<CrmCustomerOperationChanceVO> paging(CrmCustomerOperationChanceQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 逻辑删除
     *
     * @param operIds 客户经营主键集合
     */
    void deleteSoftByOperIds(List<Long> operIds);

    /**
     * 变更参与者
     *
     * @param key
     * @param userIds
     */
    void updateInvolvedUser(Long key, List<Long> userIds);


    /**
     * 更新为已读
     *
     * @param keys 主键集合
     */
    void updateIsRead(List<Long> keys);

    /**
     * 查询日志列表
     *
     * @param id id
     * @return {@link List}<{@link PrdSystemLogVO}>
     */
    List<PrdSystemLogVO> queryLogList(Long id);
}
