package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author wangly
 * @Description:线索选项配置
 * @date 2023/06/06 - 11:38
 */
@Getter
@Setter
public class CrmLeadsOptionVO  extends BaseViewModel implements Serializable {

    /**
     * 线索编号
     */
    @ApiModelProperty("线索编号")
    private String leadsNo;

    /**
     * 线索名称
     */
    @ApiModelProperty("线索名称")
    private String leadsName;
    /**
     * 客户名称
     */
    @ApiModelProperty("企业名称")
    private String customerName;
    /**
     * 线索阶段
     */
    @ApiModelProperty("线索阶段")
    private String leadsStage;
    @UdcName(udcName = "crm:leads_stage",codePropName = "leadsStage")
    private String leadsStageDesc;

    /**
     * 需求产品
     */
    @ApiModelProperty("需求产品")
    private String demandProduct;

    /**
     * 需求产品
     */
    @ApiModelProperty("需求产品")
    @UdcName(udcName = "crm:leads_demand_product",codePropName = "demandProduct")
    private String demandProductDesc;
    /**
     * 客户联系人
     */
    @ApiModelProperty("客户联系人")
    private String customerContacts;
    /**
     * 联系人电话
     */
    @ApiModelProperty("联系人电话")
    private String contactsPhone;

    /**
     * 邮箱
     */
    @ApiModelProperty("邮箱")
    private String contactsEmail;

    /**
     * 客户级别
     */
    private String customerGrade;
    @UdcName(udcName = "crm:customer_grade",codePropName = "customerGrade")
    private String customerGradeDesc;

    /**
     * 线索状态
     */
    private String leadsStatus;
    @UdcName(udcName = "crm:leads_status",codePropName = "leadsStatus")
    private String leadsStatusDesc;

    /**
     * 报备时间
     */
    @ApiModelProperty("报备时间")
    private LocalDateTime createTime;

    /**
     * 销售人员id
     */
    @ApiModelProperty("销售人员id")
    private Long saleUserId;

    /**
     * 销售人员名称
     */
    @ApiModelProperty("销售人员名称")
    @UdcName(udcName = "USER",codePropName = "saleUserId")
    private String saleUserName;

    /**
     * 客户行业
     */
    @ApiModelProperty("客户行业")
    private String customerIndustry;

    /**
     * 客户行业
     */
    @ApiModelProperty("客户行业")
    @UdcName(udcName = "crm:leads_customer_industry",codePropName = "customerIndustry")
    private String customerIndustryDesc;

    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private Long count;

    /**
     * 配置选项
     */
    @ApiModelProperty("配置选项")
    private String option;

    /**
     * 近海Id主键
     */
    @ApiModelProperty("近海Id主键")
    private Long offshoreId;
}
