package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @Author carl.wang
 * @Description 商机外包费用
 * @Date
 **/

@Data

public class CrmOpportunityOutCostVO extends BaseViewModel {
    /**
     * 商机ID
     */
    private Long oppoId;
    /**
     * 序号
     */
    private Integer sortNo;
    /**
     * 激活状态  1 未激活   0 激活
     */
    private String activataStatus;
    private String activataStatusName;

    public String getActivataStatusName() {
        return activataStatusName;
    }

    /**
     * 审批状态
     */
    private String approvalStatus;
    private String approvalStatusName;

    /**
     * 费用描述
     */
    private String costDesc;
    /**
     * 申请人id
     */
    private Long applyUserId;

    public Long getApplyUserId() {
        return getCreateUserId();
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    /**
     * 申请人
     */
    private String applyUserName;
    /**
     * 申请日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate applyDate;


    /**
     * 流程审批状态
     */
    private ProcInstStatus procInstStatus;
    private String procInstStatusDesc;

    public String getProcInstStatusDesc() {
        if (null == procInstStatus) {
            return "";
        }
        return procInstStatus.getDesc();
    }

    /**
     * 提交时间
     */
    private LocalDateTime submitTime;

    /**
     * 审批时间
     */
    private LocalDateTime approvedTime;


}
