package com.elitesland.tw.tw5.api.prd.file.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;

/**
 * 附件 文件
 *
 * @author duwh
 * @date 2022/09/20
 */
@Data
public class PrdFileQuery extends TwQueryParam {

    /**
     * 文件夹主键
     */
    @Query()
    private Long folderId;

    /**
     * 文件名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String name;

    /**
     * 原文件名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String fileName;

    /**
     * 真实文件名
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String realName;

    /**
     * 文件路径
     */
    private String serverPath;

    /**
     * 格式后缀
     */
    @Query()
    private String suffix;

    /**
     * 文件类型
     */
    @Query()
    private String fileType;

    /**
     * 文件类型desc
     */
    @Query()
    private String fileTypeDesc;

    /**
     * 文件大小(字节)
     */
    private Long fileSize;

    /**
     * 最新版本主键
     */
    @Query()
    private Long versionId;

    /**
     * 最新版本号
     */
    @Query()
    private String versionNo;

    /**
     * 版本标记
     * 版本文件，0：非版本文件，1：版本文件
     */
    @Query()
    private Integer versionFlag;

}
