package com.elitesland.tw.tw5.api.prd.file.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.file.payload.PrdFilePayload;
import com.elitesland.tw.tw5.api.prd.file.query.PrdFileQuery;
import com.elitesland.tw.tw5.api.prd.file.vo.PrdFileVO;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.List;

/**
 * 附件 - 文件
 *
 * @author duwh
 * @date 2022/09/22
 */
public interface PrdFileService {

    /**
     * 上传
     *
     * @param name     名字
     * @param folderId 文件夹id
     * @param file     文件
     * @return {@link PrdFileVO}
     */
    PrdFileVO upload(String name, Long folderId, MultipartFile file);

    /**
     * 根据合同模板名称创建空文件
     *
     * @param name     名字
     * @param folderId 文件夹id
     * @return {@link PrdFileVO}
     */
    PrdFileVO createByContractTemp(String name, Long folderId) throws IOException;

    /**
     * 获取文件路径
     *
     * @param type 类型
     * @return {@link String}
     */
    String getFilePath(String type);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link PrdFileVO}
     */
    PrdFileVO insert(PrdFilePayload payload);



    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link PrdFileVO}
     */
    PrdFileVO update(PrdFilePayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdFileVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link PrdFileVO}>
     */
    List<PrdFileVO> queryList(PrdFileQuery query);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdFileVO> paging(PrdFileQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);
}
