package com.elitesland.tw.tw5.api.prd.my.service;

import com.elitesland.tw.tw5.api.prd.my.payload.VacationPlayload;
import com.elitesland.tw.tw5.api.prd.my.vo.VacationVO;

import java.time.LocalDate;
import java.util.List;

/**
 * @author sunxw
 * @description 假期
 * @Date 2023/5/9
 */
public interface VacationService {

    /**
     * 查询时间范围内的工作小时数
     *
     * @param startDate
     * @param endDate
     * @return 总计小时数
     */
    Double selectWorkHoursByDate(LocalDate startDate, LocalDate endDate);

    /**
     * 根据时间范围查询假期
     *
     * @param startDate
     * @param endDate
     * @return
     */
    List<VacationVO> findListByDate(LocalDate startDate, LocalDate endDate);

    /**
     * 根据年份查询假期
     *
     * @param year 年份
     * @return
     */
    List<VacationVO> findListByYear(int year);

    /**
     * 保存假期
     *
     * @param list 假期实体列表
     */
    void saveVacation(List<VacationPlayload> list);

    /**
     * 保存假期jde配置
     *
     * @param list
     */
    void saveJdeExport(List<VacationPlayload> list);

}
