package com.elitesland.tw.tw5.api.prd.sale.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.common.annotation.Query;
import lombok.Data;

/**
 * 合同模板
 *
 * @author duwh
 * @date 2022/09/27
 */
@Data
public class SaleContractTempQuery extends TwQueryParam {

    /**
     * 类别id
     */
    @Query()
    private Long categoryId;

    /**
     * 标签id
     */
    @Query()
    private Long tagId;

    /**
     * 名称
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String name;

    /**
     * 编号
     */
    @Query(type = Query.Type.INNER_LIKE)
    private String tempNo;

    /**
     * 缩略图
     */
    private String thumbnail;

    /**
     * 隐藏标志 0：不隐藏，1：隐藏
     */
    @Query()
    private Integer hiddenFlag;

    /**
     * 排序
     */
    private Integer sortNo;

}
