package com.elitesland.tw.tw5.api.prd.sale.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractTempPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractTempQuery;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractTempVO;

import java.util.List;

/**
 * 合同模板
 *
 * @author duwh
 * @date 2022/09/27
 */
public interface SaleContractTempService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link SaleContractTempVO}
     */
    SaleContractTempVO insert(SaleContractTempPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link SaleContractTempVO}
     */
    SaleContractTempVO update(SaleContractTempPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    SaleContractTempVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link SaleContractTempVO}>
     */
    List<SaleContractTempVO> queryList(SaleContractTempQuery query);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<SaleContractTempVO> paging(SaleContractTempQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
