package com.elitesland.tw.tw5.api.prd.shorturl.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 短链服务配置
 *
 * @author duwh
 * @date 2023-05-19
 */
@Getter
@Setter
public class ShortUrlConfQuery extends TwQueryParam implements Serializable{
    /** 记录唯一ID 精确 */
    @ApiModelProperty("记录唯一ID")
    private Long id;
    /** 短链地址-相对地址 */
    @ApiModelProperty("短链地址-相对地址")
    private String shortUrlRelative;
    /** 短链地址前缀 精确 */
    @ApiModelProperty("短链地址前缀")
    private String shortUrlPre;
    /** 长链地址后缀 精确 */
    @ApiModelProperty("长链地址后缀")
    private String longUrlPre;
    /**
     * 数据归属租户id
     */
    private Long secTenantId;
    /** 拓展1 精确 */
    @ApiModelProperty("拓展1")
    private String ext1;
    /** 拓展2 精确 */
    @ApiModelProperty("拓展2")
    private String ext2;
    /** 拓展3 精确 */
    @ApiModelProperty("拓展3")
    private String ext3;
    /** 拓展4 精确 */
    @ApiModelProperty("拓展4")
    private String ext4;
    /** 拓展5 精确 */
    @ApiModelProperty("拓展5")
    private String ext5;
}
