package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdMessageConfigQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;

import java.time.LocalDateTime;
import java.util.List;

/**
 * service
 *
 * @author wangding
 */
public interface PrdMessageConfigService {
    /**
     * 批量消息处理
     *
     * @param configVOS
     */
    void releaseMessage(List<PrdMessageConfigVO> configVOS);

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdMessageConfigVO insert(PrdMessageConfigPayload payload);

    /**
     * 保存并发布
     *
     * @param payload 单据数据
     */
    PrdMessageConfigVO release(PrdMessageConfigPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdMessageConfigPayload payload);

    /**
     * 撤回
     *
     * @param keys 主键
     */
    boolean recall(List<Long> keys);

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    boolean delete(List<Long> keys);

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    boolean deleteSoft(List<Long> keys);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdMessageConfigVO queryByKey(Long key);

    /**
     * 通过通知范围查询通知数据
     *
     * @param noticeScope 通知范围
     * @return vo对象
     */
    List<TwCommonVO> queryDatas(String noticeScope);

    /**
     * 分页查询
     *
     * @return 分页结果
     */
    PagingVO<PrdMessageConfigVO> paging(PrdMessageConfigQuery query);

    /**
     * 一键发布
     *
     * @param keys
     * @return
     */
    boolean onKeyRelease(List<Long> keys);

    /**
     * 处理定时发布的消息
     *
     * @param param 消息id字符串
     * @return
     */
    void onJobHandlerRelease(String param);


    /**
     * 获取我的配置选择项
     *
     * @param releaseSource 发布来源
     * @return vo对象
     */
    List<TwCommonVO> queryMyDatas(String releaseSource);


    Object sendMessageConfig(PrdMessageConfigVO configVO, Object content, String noticeScope, String noticeSource);

    void addJobMessage(Long objectId, String action, LocalDateTime triggerTime, String createSource, String noticeSource, String title, String content, String urlTitle, String url);

    List<PrdMessageConfigVO> queryByObjectIdAndAction(Long objectId, String action);

    PrdMessageConfigVO queryByMessageCode(String messageCode);
}
