package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRemindPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRemindQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRemindVO;

import java.util.List;

/**
 * service
 *
 * @author wangding
 */
public interface PrdSystemRemindService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdSystemRemindVO insert(PrdSystemRemindPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdSystemRemindPayload payload);

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    boolean delete(List<Long> keys);

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    boolean deleteSoft(List<Long> keys);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdSystemRemindVO queryByKey(Long key);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdSystemRemindVO> paging(PrdSystemRemindQuery query);

    /**
     * 判断是否允许返回
     *
     * @param remindCode 消息提醒码
     * @return 是否允许返回
     */
    boolean allowReturn(String remindCode, TwCommonPayload payload);

    /**
     * 列表查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    List<PrdSystemRemindVO> selectByCondition(PrdSystemRemindQuery query);
}
