package com.elitesland.tw.tw5.api.common.funConfig.service;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessPagePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessPageQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessPageSearchJsonQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessPageListVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessPageVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 页面配置
 *
 * @author duwh
 * @date 2023-06-20
 */
public interface BusinessPageService {

    PagingVO<BusinessPageListVO> querySimplePaging(BusinessPageQuery query);

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessPageVO}>
     */
    PagingVO<BusinessPageVO> queryPaging(BusinessPageQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessPageVO}>
     */
    List<BusinessPageVO> queryListDynamic(BusinessPageQuery query);

    List<BusinessPageListVO> querySimpleListDynamic(BusinessPageQuery query);

    /**
     * 统计
     *
     * @param query 查询
     * @return {@link Long}
     */
    Long count(BusinessPageQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessPageVO}
     */
    BusinessPageVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessPageVO}
     */
    BusinessPageVO insert(BusinessPagePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessPageVO}
     */
    BusinessPageVO update(BusinessPagePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessPagePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    BusinessPageVO getJson(BusinessPageSearchJsonQuery query);

    BusinessPageVO getByCode(String code);
}
