package com.elitesland.tw.tw5.api.common.funConfig.service;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTableFieldsPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableFieldsQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableFieldsVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 业务对象字段明细
 *
 * @author duwh
 * @date 2023-06-14
 */
public interface BusinessTableFieldsService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link BusinessTableFieldsVO}>
     */
    PagingVO<BusinessTableFieldsVO> queryPaging(BusinessTableFieldsQuery query);

    /**
     * 查询数据库的表字段数据数据
     *
     * @param tableName 表名
     * @return {@link List}<{@link BusinessTableFieldsVO}>
     */
    List<BusinessTableFieldsVO> query(String tableName);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link BusinessTableFieldsVO}>
     */
    List<BusinessTableFieldsVO> queryListDynamic(BusinessTableFieldsQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link BusinessTableFieldsVO}
     */
    BusinessTableFieldsVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link BusinessTableFieldsVO}
     */
    BusinessTableFieldsVO insert(BusinessTableFieldsPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link BusinessTableFieldsVO}
     */
    BusinessTableFieldsVO update(BusinessTableFieldsPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(BusinessTableFieldsPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 同步字段数据
     *
     * @param tableIdList 表id列表
     */
    void syncColumn(List<Long> tableIdList);
}
