package com.elitesland.tw.tw5.api.demo.student.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitesland.tw.tw5.api.common.TwCommonVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 学生VO
 * @author zhangyongqiang
 */

@Getter
@Setter
@Where(clause = " delete_flag = 0 ")
public class DemoStudentVO extends TwCommonVO implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 学号
     */
    @ApiModelProperty("学号")
    private String studentNo;

    /**
     * 姓名
     */
    @ApiModelProperty("姓名")
    private String studentName;

    /**
     * 年龄
     */
    @ApiModelProperty("年龄")
    private Integer age;

    /**
     * 性别
     */
    @ApiModelProperty("性别")
    private String sex;

    /**
     * 生日
     */
    @ApiModelProperty("生日")
    private LocalDate birthday;

    /**
     * 班级Id
     */
    @ApiModelProperty("班级Id")
    private Long  classId;

    /**
     * 班级名称
     */
    @ApiModelProperty("班级名称")
    private String  className;
}
