package com.elitesland.tw.tw5.api.log.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import lombok.Getter;
import lombok.Setter;

/**
 * 日志记录
 *
 * @author duwh
 * @date 2023-02-03
 */
@Getter
@Setter
public class LogVO extends BaseViewModel {
    /**
     * 描述
     */
    private String description;
    /**
     * 日志类型 ERROR INFO
     */
    private String logType;
    /**
     * 方法路径
     */
    private String method;
    /**
     * 参数
     */
    private String params;
    /**
     * ip来源
     */
    private String requestIp;
    /**
     * 耗时
     */
    private Long time;
    /**
     * 请求所属地址
     */
    private String address;
    /**
     * 浏览器
     */
    private String browser;
    /**
     * 异常详情
     */
    private byte[] exceptionDetail;

    private String exception;

    public String getException() {
        if (null != exceptionDetail && !exceptionDetail.equals((Object) null)) {
            return new String(exceptionDetail);
        } else {
            return "";
        }
    }
}
