package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @Author carl.wang
 * @Description 市场活动表
 * @Date
 **/

@Data

public class CrmActActivityPayload extends TwCommonPayload {
    /**
     * 计划Id
     */
    private Long planId;

    /**
     * 计划明细id
     */
    private Long detailId;
    /**
     * 项目名称（活动名称）
     */
    private String projectName;
    /**
     * 项目编号（活动编号）
     */
    private String projectNo;
//    /**
//     * 操作状态 save:保存 submit:提交
//     */
//    private String opeStatus;
    /**
     * 项目开始时间（活动开始时间）
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate startTime;
    /**
     * 项目结束时间（活动结束时间）
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private LocalDate endTime;
    /**
     * 负责人id
     */
    private Long manageUserId;
    /**
     * 组织（部门，BU）id
     */
    private Long orgId;
    /**
     * 公司id
     */
    private Long companyId;
    /**
     * 附件地址codes（“，”分割字符串）
     */
    private String fileCodes;

    /**
     * 项目状态
     */
    private String projectStatus;

    /**
     * 关闭原因
     */
    private String closeReason;

    /**
     * 关闭备注
     */
    private String clsoeRemark;

    /**
     * 活动规模
     */
    private String activityScale;

    /**
     * 活动地址
     */
    private String activityAddr;

    /**
     * 活动目标
     */
    private String activityTarget;

    /**
     * 人力总人天
     */
    private Integer personNum;
    /**
     * 人力费用
     */
    private BigDecimal personMoney;
    /**
     * 人力资源
     */
    private String personSource;
    /**
     * 报销费用
     */
    private BigDecimal claimMoney;
    /**
     * 采购费用
     */
    private BigDecimal purchaseMoney;
    /**
     * 杂项费用
     */
    private BigDecimal sundryMoney;
    /**
     * 费用预算（除去人力费用）
     */
    private BigDecimal budgetMoney;
    /**
     * 预算总额
     */
    private BigDecimal totalMoney;

    /**
     * 潜在客户
     */
    private Integer potentialCustomer;
    /**
     * 线索
     */
    private Integer leadNum;

    /**
     * 商机
     */
    private Integer busOps;
    /**
     * 产出预估总数
     */
    private BigDecimal pipeline;


    /**
     * 是否是更新操作
     */
    private Integer planChangeFlag;

    @ApiModelProperty("流程提交标志")
    private Boolean submit;

    /**
     * 流程定义KEY
     */
    private String procDefKey;

    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

    /**
     * 保存
     */
    private Boolean doSave;

    /**
     * 是否发布了公告，未发布：0，不发布：1，已发布：2
     */
    private Integer isRelease = 0;


}
