package com.elitesland.tw.tw5.api.prd.crm.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import lombok.Data;

/**
 * @Author carl.wang
 * @Description 客户表
 * @Date
 **/

@Data

public class CrmCustomerPayload extends TwCommonPayload {

    /**
     * 请求来源 示例：销售拜访任务（访销计划任务 sell_visit_plan）
     */
    private String from;

    /**
     * 拜访任务主键
     */
    private Long visitTaskId;
    /**
     * 地址簿id
     */
    private Long bookId;
    /**
     * 客户状态(激活，暂挂)
     */
    private String customerStatus;
    /**
     * 客户名称
     */
    private String customerName;
    /**
     * 客户级别
     */
    private String customerGrade;

    /**
     * 客户来源
     */
    private String customerSource;
    /**
     * 客户行业
     */
    private String companyIndustry;

    /**
     * 电话
     */
    private String companyPhone;

    /**
     * 邮箱
     */
    private String companyEmail;

    /**
     * 传真
     */
    private String companyFax;
    /**
     * 省
     */
    private String province;
    /**
     * 省
     */
    private String provinceName;
    /**
     * 市
     */
    private String city;
    /**
     * 市
     */
    private String cityName;
    /**
     * 区
     */
    private String district;
    /**
     * 区
     */
    private String districtName;
    /**
     * 详细地址
     */
    private String companyAddress;

    /**
     * 网址
     */
    private String companyWebsite;
    /**
     * 规模
     */
    private String companyScale;
    /**
     * 税号
     */
    private String taxNo;
    /**
     * 交易货币
     */
    private String currency;
    /**
     * 语言
     */
    private String language;
    /**
     * 公司性质
     */
    private String companyNature;

    /**
     * 服务负责人
     */
    private Long serviceUserId;
    /**
     * 商务负责人
     */
    private Long businessUserId;

    /**
     * 关怀负责人
     */
    private Long careUserId;

    /**
     * 运维售后负责人
     */
    private Long operationUserId;

    /**
     * 修改类型：0修改，1变更负责人
     */
    private Integer updateType = 0;

    /**
     * 经纬度
     */
    private String longitudeLatitude;
}
