package com.elitesland.tw.tw5.api.prd.crm.query;

import com.elitesland.tw.tw5.api.common.TwQueryParam;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

/**
 * @author zoey
 * @Description:线索跟进表
 * @date 2022/5/17 - 11:39
 */
@Data
public class CrmFollowQuery extends TwQueryParam {

    /**
     * 跟进对象
     */
    private String followObject;


    /**
     * 对象id
     */
    private Long objectId;

    /**
     * 跟进类型
     */
    private String followType;

    /**
     * 跟进内容
     */
    private String followContent;

    /**
     * 附件地址
     */
    private String fileCodes;

    /**
     * 跟进时间  创建时间区间开始
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTimeStart;

    /**
     * 跟进时间  创建时间区间结束
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createTimeEnd;

//    /**
//     * 线索id
//     */
//    private Long leadsId;
//
//    /**
//     * 商机id
//     */
//    private Long opportunityId;
//
//    /**
//     * 项目id
//     */
//    private Long projectId;
//
//
//    /**
//     * 潜在客户id
//     */
//    private Long potentialCustomerId;
//
//    /**
//     * 客户id
//     */
//    private Long customerId;
//
//    /**
//     * 联系人id
//     */
//    private Long contactsId;

}
