package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationPartnersPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationPartnersQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationPartnersVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
* 客户经营-工商股东（含历史）
*
* @author duwh
* @date 2022-12-05
*/
public interface CrmCustomerOperationPartnersService {

    /**
    * 分页列表
    *
    * @param query 条件
    * @return {@link PagingVO}<{@link CrmCustomerOperationPartnersVO}>
    */
    PagingVO<CrmCustomerOperationPartnersVO> paging(CrmCustomerOperationPartnersQuery query);

    /**
    * 查询列表
    *
    * @param query 条件参数
    * @return {@link List}<{@link CrmCustomerOperationPartnersVO}>
    */
    List<CrmCustomerOperationPartnersVO> queryList(CrmCustomerOperationPartnersQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CrmCustomerOperationPartnersVO}
     */
    CrmCustomerOperationPartnersVO queryByKey(Long key);

    /**
    * 新增
    *
    * @param payload 单据数据
    * @return {@link CrmCustomerOperationPartnersVO}
    */
    CrmCustomerOperationPartnersVO insert(CrmCustomerOperationPartnersPayload payload);

    /**
    * 修改
    *
    * @param payload 单据数据
    */
    CrmCustomerOperationPartnersVO update(CrmCustomerOperationPartnersPayload payload);

    /**
    * 逻辑删除
    *
    * @param keys 主键集合
    */
    void deleteSoft(List<Long> keys);

    /**
    * Excel导出数据
    *
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    void download(List<CrmCustomerOperationPartnersVO> all, HttpServletResponse response) throws IOException;
}
