package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanDetailMemberListPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOperationPlanDetailMemberPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailMemberQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailMemberVO;

import java.util.List;

/**
 * 客户经营-经营计划参与者
 *
 * @author duwh
 * @date 2022/11/21
 */
public interface CrmOperationPlanDetailMemberService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link CrmOperationPlanDetailMemberVO}
     */
    CrmOperationPlanDetailMemberVO insert(CrmOperationPlanDetailMemberPayload payload);

    /**
     * 批量新增
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link CrmOperationPlanDetailMemberVO}>
     */
    List<CrmOperationPlanDetailMemberVO> savaAll(CrmOperationPlanDetailMemberListPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link CrmOperationPlanDetailMemberVO}
     */
    CrmOperationPlanDetailMemberVO update(CrmOperationPlanDetailMemberPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    CrmOperationPlanDetailMemberVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link CrmOperationPlanDetailMemberVO}>
     */
    List<CrmOperationPlanDetailMemberVO> queryList(CrmOperationPlanDetailMemberQuery query);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<CrmOperationPlanDetailMemberVO> paging(CrmOperationPlanDetailMemberQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 根据经营计划主键id集合 逻辑删除数据
     *
     * @param planDetailIds 经营计划主键
     */
    void deleteSoftByPlanDetailIds(List<Long> planDetailIds);

    /**
     * 根据客户经营主键id集合 逻辑删除数据
     *
     * @param operIds 客户经营主键
     */
    void deleteSoftByOperIds(List<Long> operIds);

    /**
     * 批量保存
     *
     * @param planDetailPayloadS 请求集合
     */
    void saveAll(List<CrmOperationPlanDetailMemberPayload> planDetailPayloadS);
}
