package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsDetailPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPotentialCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpenseaOptionQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPotentialCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpenseaOptionVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPotentialCustomerListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPotentialCustomerVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * @author zoey
 * @Description:
 * @date 2022/6/14 - 11:49
 */
public interface CrmPotentialCustomerService {
    CrmPotentialCustomerVO saveOne(CrmPotentialCustomerPayload payload);

    void dynamicUpdate(CrmPotentialCustomerPayload payload);

    /**
     * 省市区更新，可能需要清空值，所以单独处理
     * @param payload
     */
    void updateProvinceCityDistrict(CrmPotentialCustomerPayload payload);

    List<PrdSystemLogVO> queryLogList(Long objectId);

    PagingVO<PrdSystemLogVO> pageLog(PrdSystemLogQuery query);

    List<CrmPotentialCustomerListVO> queryList(CrmPotentialCustomerQuery query);

    CrmPotentialCustomerVO queryDetail(Long id);

    void deletePotentialCustomerSoft(Long[] keys);


    long countByActivityId(Long activityId);

    Object paging(CrmPotentialCustomerQuery query);

    void transferPotentialCustomerOpensea(CrmPotentialCustomerPayload payload);
    Long transferPotentialCustomerOffshore(CrmLeadsDetailPayload payload);

    void transferPotentialCustomerOpenseaBatch(List<CrmPotentialCustomerPayload> payloads);

    void updateFollow(CrmFollowPayload payload);

    void downloadBatch(HttpServletResponse response, CrmPotentialCustomerQuery query);

    Map<String,Object> importBatch(HttpServletResponse response, MultipartFile file, Boolean force);


    void deleteOpenseaSoft(Long openseaId, Long newOpenseaId);

    Map<String, Object> importBatchPro(MultipartFile file, Boolean force) throws InterruptedException;

    void batchAddTags(Long[] keys, String tagIds);

    void batchDelTags(Long[] keys, String tagIds);


    //公海查重分页
    PagingVO<CrmOpenseaOptionVO> repeatPaging(CrmOpenseaOptionQuery query);


    //公海查重详情分页
    PagingVO<CrmOpenseaOptionVO> repeatDeatilPaging(CrmOpenseaOptionQuery query);
}
