package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.tw.tw5.api.udc.UdcName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 商机查重
 * @author likunpeng
 * @date 2023/6/8
 */
@Getter
@Setter
public class CrmOpportunityOptionVO extends BaseViewModel implements Serializable {
    /**
     * 项目id
     */
    @ApiModelProperty("项目Id")
    private Long projectId;
    /**
     * 商机编号
     */
    @ApiModelProperty("商机编号")
    private String projectNo;
    /**
     * 商机名称
     */
    @ApiModelProperty("商机名称")
    private String projectName;
    /**
     * 客户id 老客户才会选择
     */
    @ApiModelProperty("客户id")
    private Long custBookId;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String custBookName;
    /**
     * 线索id
     */
    @ApiModelProperty("线索id")
    private Long leadsId;
    /**
     * 线索名称
     */
    @ApiModelProperty("线索名称")
    private String leadsName;
    /**
     * 销售产品
     */
    @ApiModelProperty("销售产品")
    private String saleProduct;
    /**
     * 销售阶段
     */
    @ApiModelProperty("销售阶段")
    private String salePhase;
    @UdcName(udcName = "crm:oppo:sale_stage", codePropName = "salePhase")
    private String salePhaseName;
    /**
     * 客户联系人
     */
    @ApiModelProperty("客户联系人")
    private String contactName;
    /**
     * 客户联系电话
     */
    @ApiModelProperty("客户联系人电话")
    private String contactPhone;
    /**
     * 签单buId
     */
    @ApiModelProperty("签单buId")
    private Long orgId;
    @UdcName(udcName = "BU", codePropName = "orgId")
    private String orgName;
    /**
     * 签单负责人id
     */
    @ApiModelProperty("签单负责人id")
    private Long manageUserId;
    @UdcName(udcName = "USER", codePropName = "manageUserId")
    private String manageUserName;
    /**
     * 交付BU_ID
     */
    @ApiModelProperty("交付BU_ID")
    private Long deliOrgId;
    @UdcName(udcName = "BU", codePropName = "deliOrgId")
    private String deliOrgName;
    /**
     * 交付负责人ID
     */
    @ApiModelProperty("交付负责人Id")
    private Long deliUserId;
    @UdcName(udcName = "USER", codePropName = "deliUserId")
    private String deliUserName;
    /**
     * 内部来源BU_ID（线索来源BU）
     */
    @ApiModelProperty("内部来源BU_ID")
    private Long internalOrgId;
    @UdcName(udcName = "BU", codePropName = "internalOrgId")
    private String internalOrgName;
    /**
     * 内部来源人ID
     */
    @ApiModelProperty("内部来源人ID")
    private Long internalUserId;
    @UdcName(udcName = "USER", codePropName = "internalUserId")
    private String internalUserName;
    /**
     * 创建人（报备人）
     */
    @ApiModelProperty("创建人（报备人）")
    private String createUserName;
    /**
     * 商机状态
     */
    @ApiModelProperty("商机状态")
    private String projectStatus;
    /**
     * 商机状态名称
     */
    @ApiModelProperty("商机状态名称")
    private String projectStatusName;
    /**
     * 商机级别
     */
    @ApiModelProperty("商机级别")
    private String oppoLevel;
    @UdcName(udcName = "crm:oppo:level", codePropName = "oppoLevel")
    private String oppoLevelName;
    /**
     * 成单概率
     */
    @ApiModelProperty("成单概率")
    private String probability;
    @UdcName(udcName = "crm:oppo:trans_proba", codePropName = "probability")
    private String probabilityName;
    /**
     * 客户行业
     */
    @ApiModelProperty("客户行业")
    private String custIdst;
    /**
     * 客户行业名稱
     */
    @ApiModelProperty("客户行业名稱")
    private String custIdstName;

    /**
     * 数量
     */
    @ApiModelProperty("数量")
    private Long count;

    /**
     * 配置选项
     */
    @ApiModelProperty("配置选项")
    private String option;
}
