package com.elitesland.tw.tw5.api.prd.crm.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpenseaPayload;
import com.elitesland.tw.tw5.api.prd.prj.payload.PrjProjectPayload;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemTagVO;
import lombok.Data;

import java.util.List;

/**
 * @author zoey
 * @Description:潜在客户表
 * @date 2022/5/17 - 14:13
 */
@Data
public class CrmPotentialCustomerVO extends BaseViewModel {

    /**
     * 公海
     **/
    private CrmOpenseaPayload opensea;

    /**
     * 市场活动
     **/
    private PrjProjectPayload market;

    /**
     * 标签id
     */
    private String tagIds;

    /**
     * 标签
     */
    private List<PrdSystemTagVO> tags;

    /**
     * 客户名称
     **/
    private String customerName;

    /**
     * 客户编号
     **/
    private String customerNo;

    /**
     * 客户状态
     **/
    private String customerStatus;
    private String customerStatusDesc;

    /**
     * 客户级别
     **/
    private String customerGrade;
    private String customerGradeDesc;

    /**
     * 客户行业
     */
    private String customerIndustry;
    private String customerIndustryDesc;

    /**
     * 联系人姓名
     **/
    private String customerContacts;

    /**
     * 客户电话
     **/
    private String customerPhone;

    /**
     * 客户邮箱
     **/
    private String customerEmail;

    /**
     * 客户地址-省
     **/
    private String customerLocationProvince;

    /**
     * 客户地址-市
     **/
    private String customerLocationCity;

    /**
     * 客户地址-区
     **/
    private String customerLocationDistrict;

    /**
     * 客户地址-详细地址
     **/
    private String customerLocationDetail;

    /**
     * 创建人姓名
     */
    private String createUserName;

    /**
     * 客户地址-省
     **/
    private String customerLocationProvinceName;

    /**
     * 客户地址-市
     **/
    private String customerLocationCityName;

    /**
     * 客户地址-区
     **/
    private String customerLocationDistrictName;


    /**
     * 转移原因
     */
    private String transferReason;

    /**
     * 需求产品
     */
    private String demandProduct;
    private String demandProductDesc;

    /**
     * 客户区域
     */
    private String custRegion;
    private String custRegionDesc;

    /**
     * 市场渠道
     */
    private String marketChannel;
    private String marketChannelDesc;

    /**
     * 联系人部门
     */
    private String contactsDepartment;

    /**
     * 联系人岗位
     */
    private String contactsPosition;

    /**
     * 业务伙伴主键 business_partner.id
     */
    private Long partnerId;

}
