package com.elitesland.tw.tw5.api.prd.my.service;


import com.elitesland.tw.tw5.api.prd.app.vo.PrdUserDataForAppVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserCompositeVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserRemindVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TwRecentWorkVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemMenuVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * service
 *
 * @author wangding
 */
public interface PrdUserService {

    /**
     * 查询用户复合能力
     *
     * @return result
     */
    List<PrdUserCompositeVO> queryUserComposite(Long userId);

    /**
     * 查询用户详情
     *
     * @return result
     */
    PrdUserDataVO queryUserDetail();

    /**
     * 获取用户基本信息
     *
     * @return {@link PrdUserDataVO}
     */
    PrdUserDataVO getUserInfoBase();

    PrdUserDataForAppVO queryDetailForMobile();

    /**
     * 修改个人快捷入口
     *
     * @param shortcutIds 快捷入口ids
     * @return result
     */
    Long updateShortcut(String shortcutIds);

    /**
     * 修改密码
     *
     * @param oldPassword 当前密码
     * @param newPassword 新密码
     * @return result
     */
    void updatePassword(String oldPassword, String newPassword);

    /**
     * 查询我的工作代办
     *
     * @return result
     */
    List<TwRecentWorkVO> findMyWork();


    /**
     * 查询我的提醒
     *
     * @return result
     */
    List<PrdUserRemindVO> findMyRemind();

    /**
     * 操作我的提醒
     *
     * @param noticeType 提醒类型
     * @return result
     */
    Boolean updateMyRemind(String noticeType);

    /**
     * 查询用户数据
     *
     * @return result
     */
    void queryUserByTicket(HttpServletRequest request, HttpServletResponse response);

    /**
     * 查询我的所有组织
     *
     * @return result
     */
    List<PrdOrgDataRefVO> queryOrgList();

    /**
     * 查询我的所有下级
     *
     * @return result
     */
    List<PrdOrgEmployeeRefVO> queryLowListByKey(Long orgId);

    /**
     * 查询我的所有菜单
     *
     * @return result
     */
    List<PrdSystemMenuVO> queryMenus();


    /**
     * 通过组织id和系统角色 查询有哪些人
     *
     * @return result
     */
    List<PrdUserDataVO> queryPrdUserDataByOrgIdAndSystemRole(Long orgId,String systemRole);

    /**
     * 通过userId查询这个人有哪些系统角色
     *
     * @return result
     */
    List<PrdSystemRoleVO> querySystemRoleByUserId(Long userId);
}
