package com.elitesland.tw.tw5.api.prd.org.payload;

import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class PrdOrgTenantEmployeePayload extends TwCommonPayload {
    /**
     * 租户管理员id
     */
    private Long adminUserId;
    /**
     * 租户管理员账号
     */
    private String adminAccount;

    /**
     * 租户id
     */
    private String tenantId;

    /** 租户编码 */
    @ApiModelProperty("租户编码")
    private String tenantCode;
    /** 租户名称 */
    @ApiModelProperty("租户名称")
    private String tenantName;
    /** 租户类型 */
    @ApiModelProperty("租户类型")
    private String tenantType;
    /** 是否初始化 */
    @ApiModelProperty("是否初始化")
    private Boolean inited;
    /** 是否启用 */
    @ApiModelProperty("是否启用")
    private Boolean enabled;
    /** 联系人 */
    @ApiModelProperty("联系人")
    private String linkman;
    /** 联系电话 */
    @ApiModelProperty("联系电话")
    private String contactNumber;
    /** 联系地址 */
    @ApiModelProperty("联系地址")
    private String address;
    /** 租户数据隔离 */
    @ApiModelProperty("租户数据隔离")
    private String tenantIsolation;
    /** 数据库是否已初始化 */
    @ApiModelProperty("数据库是否已初始化")
    private Boolean dbInitialized;
    /** 租户数据隔离数据源 */
    @ApiModelProperty("租户数据隔离数据源")
    private Long databaseSourceId;
    /** schema名称，如果租户数据隔离通过schema */
    @ApiModelProperty("schema名称，如果租户数据隔离通过schema")
    private String schemaName;
    /** 域名地址 */
    @ApiModelProperty("域名地址")
    private String tenantDomain;
    /** 租户自定义域名 */
    @ApiModelProperty("租户自定义域名")
    private String customDomain;
    ///** 管理员登录账号 */
    //@ApiModelProperty("管理员登录账号")
    //private String adminAccount;
    /** 基础数据同步记录ID */
    @ApiModelProperty("基础数据同步记录ID")
    private Long baseDataSyncId;
    /** 所属行业，[UDC]COM:INDUSTRY */
    @ApiModelProperty("所属行业，[UDC]COM:INDUSTRY")
    private String industry;
    /** 所属客户，[UDC]SYS:CUSTOMER */
    @ApiModelProperty("所属客户，[UDC]SYS:CUSTOMER")
    private String customer;

}
