package com.elitesland.tw.tw5.api.prd.org.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.org.payload.*;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.vo.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

public interface PrdOrgOrganizationService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdOrgOrganizationVO insert(PrdOrgOrganizationPayload payload);

    /**
     * 租户数据初始化
     *
     * @param payload 有效载荷
     * @return {@link PrdOrgOrganizationVO}
     */
    PrdOrgOrganizationVO insertByTenant(PrdOrgOrganizationPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdOrgOrganizationPayload payload);


    /**
     * 修改父组织
     *
     * @param payload 单据数据
     */
    Long updateRef(PrdOrgOrganizationRefPayload payload);

    /**
     * 组织引用
     *
     * @param payload 单据数据
     */
    Long reference(PrdOrgOrganizationRefPayload payload);


    /**
     * 组织逻辑删除
     *
     * @param dimensionId 维度id orgId 组织id
     * @return result
     */
    boolean deleteSoft(Long dimensionId, Long orgId);

    /**
     * 根据维度id组织列表查询
     *
     * @return
     */
    List<PrdOrgOrganizationRefVO> queryList(Long dimensionId);

    /**
     * 全部组织查询
     *
     * @return
     */
    List<PrdOrgOrganizationRefVO> queryAll(Long dimensionId, Boolean defaultFlag);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdOrgOrganizationVO> paging(PrdOrgOrganizationQuery query);

    /**
     * 根据组织id查询员工数据
     *
     * @return
     */
    List<PrdOrgEmployeeRefVO> queryEmployeeRefList(Long orgId);

    /**
     * 根据主键组织详情查询
     *
     * @param dimensionId 维度id orgId 组织id
     * @return
     */
    PrdOrgOrganizationVO queryDetail(Long dimensionId, Long orgId);

//    /**
//     * 根据主键组织详情查询
//     *
//     * @param id 主键
//     * @return
//     */
//    PrdOrgOrganizationVO queryOrgById(Long id);

    /**
     * 根据主键查询
     *
     * @param orgId org id
     * @return {@link PrdOrgOrganizationVO}
     */
    PrdOrgOrganizationVO queryDetailSimpleByOrgId(Long orgId);

    /**
     * 添加组织员工
     *
     * @return
     */
    Long insertEmployeeRef(List<PrdOrgEmployeeRefPayload> payloads);

    /**
     * 移除组织员工
     *
     * @return
     */
    boolean deleteEmployeeRefSoft(Long orgId, List<Long> employeeIds);

    /**
     * 添加组织角色
     *
     * @return
     */
    PrdOrgRoleVO insertRole(PrdOrgRolePayload payload);

    /**
     * 修改组织角色
     *
     * @param payload 单据数据
     */
    Long updateRole(PrdOrgRolePayload payload);

    /**
     * 删除组织角色
     *
     * @param key 主键
     */
    Boolean deleteRoleSoft(Long key);

    /**
     * 组织状态修改
     *
     * @param id 主键 orgStatus状态
     */
    Long updateStatus(Long id, String orgStatus);

    /**
     * 组织关系更改
     *
     * @param payloads
     */
    Long updateOrgOrEmpRef(List<PrdOrgOrganizationDataPayload> payloads);


    Map<Long, String> queryOrgs(List<Long> asList);

    Map<Long, Long> getV4AndV5OrgIds();

    /**
     * 批量导入excle
     * @param file
     */
    void importOrganization(MultipartFile file);
}
