package com.elitesland.tw.tw5.api.prd.sale.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractQuery;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractVO;

import java.util.List;

/**
 * 合同
 *
 * @author duwh
 * @date 2022/09/27
 */
public interface SaleContractService {

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link SaleContractVO}
     */
    SaleContractVO insert(SaleContractPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link SaleContractVO}
     */
    SaleContractVO update(SaleContractPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    SaleContractVO queryByKey(Long key);

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link List}<{@link SaleContractVO}>
     */
    List<SaleContractVO> queryList(SaleContractQuery query);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<SaleContractVO> paging(SaleContractQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
