package com.elitesland.tw.tw5.api.prd.shorturl.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;


/**
  * 短链服务关系表
  *
  * @author duwh
  * @date 2023-05-19
  */
@Getter
@Setter
public class ShortUrlRefVO extends BaseViewModel implements Serializable {
    /** 短链地址 */
    @ApiModelProperty("短链地址")
    private String shortUrl;
    /** 短链地址-相对地址 */
    @ApiModelProperty("短链地址-相对地址")
    private String shortUrlRelative = "/tw-server5-crm/s/r/";

    /** 短链地址识别码 */
    @ApiModelProperty("短链地址识别码")
    private String code;
    /** 长链地址 */
    @ApiModelProperty("长链地址")
    private String longUrl;
    /** 访问数量 */
    @ApiModelProperty("访问数量")
    private Integer visitNum;
    /** 拓展1 */
    @ApiModelProperty("拓展1")
    private String ext1;
    /** 拓展2 */
    @ApiModelProperty("拓展2")
    private String ext2;
    /** 拓展3 */
    @ApiModelProperty("拓展3")
    private String ext3;
    /** 拓展4 */
    @ApiModelProperty("拓展4")
    private String ext4;
    /** 拓展5 */
    @ApiModelProperty("拓展5")
    private String ext5;
}
