package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemFunctionDataPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemFunctionDataQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemFunctionDataVO;

import java.util.List;

/**
 * service
 *
 * @author wangding
 */
public interface PrdSystemFunctionDataService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdSystemFunctionDataVO insert(PrdSystemFunctionDataPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdSystemFunctionDataPayload payload);

    /**
     * 物理删除
     *
     * @param keys 主键
     * @return result
     */
    boolean delete(List<Long> keys);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdSystemFunctionDataVO> paging(PrdSystemFunctionDataQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdSystemFunctionDataVO queryByKey(Long key);
}
