package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemProblemFeedbackPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemProblemFeedbackQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemProblemFeedbackVO;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

public interface PrdSystemProblemFeedbackService {

    /**
     * 新增
     *
     * @param payload 单条数据
     */
    PrdSystemProblemFeedbackVO insert(PrdSystemProblemFeedbackPayload payload);

    /**
     * 修改
     *
     * @param payload 单条数据
     */
    PrdSystemProblemFeedbackVO update(PrdSystemProblemFeedbackPayload payload);

    /**
     * 修改
     *
     * @param payload 根据主键动态修改单条数据
     */
    Long updateByKeyDynamic(PrdSystemProblemFeedbackPayload payload);

    /**
     * 分页查询
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<PrdSystemProblemFeedbackVO> paging(PrdSystemProblemFeedbackQuery query);

    /**
     * 通过主键查询
     * @param key 主键
     * @return vo对象
     */
    PrdSystemProblemFeedbackVO queryByKey(Long key);

    /**
     * 关闭问题
     * @param payload
     */
    void closeProblemFeedback(PrdSystemProblemFeedbackPayload payload);

    /**
     * 打开问题
     * @param payload
     */
    void openProblemFeedback(PrdSystemProblemFeedbackPayload payload);

    /**
     * 申请加急问题
     * @param payload
     */
    void urgentProblemFeedback(PrdSystemProblemFeedbackPayload payload);

    /**
     * 修改常见问题标志
     * @param payload
     */
    void commonProblemFeedback(PrdSystemProblemFeedbackPayload payload);

    /**
     * 查询时间段内的问题数量和解决数量
     * @param startDate
     * @param endDate
     * @return
     */
    Map<String, List<Map<String, Object>>> statisticalNumber(LocalDateTime startDate, LocalDateTime endDate);

    /**
     * 查询时间段内的问题类型统计
     * @param startDate
     * @param endDate
     * @return
     */
    List<Map<String, Object>> findNumberStatisticalGroupByProblemType(LocalDateTime startDate, LocalDateTime endDate);

    /**
     * 查询时间段内的问题所属功能统计
     * @param startDate
     * @param endDate
     * @return
     */
    List<Map<String, Object>> findNumberStatisticalGroupByFunctionId(LocalDateTime startDate, LocalDateTime endDate);

    /**
     * 查询待办的问题反馈数量
     * @param userId
     * @return
     */
    Long findWorkProblemFeedbackByUserId(Long userId);
}
