package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemRolePayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemRoleQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;

import java.util.List;

/**
 * service
 *
 * @author wangding
 */
public interface PrdSystemRoleService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    PrdSystemRoleVO insert(PrdSystemRolePayload payload);

    /**
     * 租户初始化数据
     *
     * @param payload 有效载荷
     * @return {@link PrdSystemRoleVO}
     */
    PrdSystemRoleVO insertByTenant(PrdSystemRolePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    Long update(PrdSystemRolePayload payload);

    /**
     * 更改状态
     *
     * @param id 主键
     */
    Long updateStatus(Long id, Boolean enable);

//    /**
//     * 物理删除
//     *
//     * @param keys 主键
//     * @return result
//     */
//    boolean delete(List<Long> keys);

    /**
     * 逻辑删除
     *
     * @param keys 主键
     * @return result
     */
    boolean deleteSoft(List<Long> keys);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    PrdSystemRoleVO queryByKey(Long key);

    /**
     * 分页查询
     *
     * @return 分页结果
     */
    PagingVO<PrdSystemRoleVO> paging(PrdSystemRoleQuery query);

    /**
     * 列表查询
     *
     * @return 结果
     */
    List<PrdSystemRoleVO> queryList();
}
