package com.elitesland.tw.tw5.api.prd.system.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemWorkTypeQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemWorkTypeVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * service
 *
 * @author wangding
 */
public interface PrdSystemWorkTypeService {


    /**
     * 修改人力成本
     *
     * @param key       主键
     * @param sysType
     * @param sysWork
     * @param sysLevel
     * @param unitPrice
     * @return
     */
    Long update(Long key, String sysType, String sysWork, String sysLevel, BigDecimal unitPrice);

    /**
     * 保存
     *
     * @param sysType   系统类型
     * @param sysWork   系统工作
     * @param sysLevel  系统级别
     * @param unitPrice 单价
     */
    void save(String sysType, String sysWork, String sysLevel, BigDecimal unitPrice);

    /**
     * 删除
     *
     * @param keys 主键
     * @return result
     */
    boolean delete(List<Long> keys);


    /**
     * 分页查询
     *
     * @return 分页结果
     */
    PagingVO<PrdSystemWorkTypeVO> paging(PrdSystemWorkTypeQuery query);

    /**
     * 列表查询
     *
     * @return 结果
     */
    Map<String, Map<String, Map<String, BigDecimal>>> queryList();


    /**
     * 批量导出excel
     *
     * @param response 请求响应
     * @param query    查询条件
     */
    void downloadPlus(HttpServletResponse response, PrdSystemWorkTypeQuery query);

    /**
     * 批量立项导入excel
     *
     * @param file 请求响应
     */
    boolean importWorkType(MultipartFile file);
}
