package com.elitesland.tw.tw5.api.prd.system.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
public class PrdSystemProblemFeedbackVO extends BaseViewModel {

    @ApiModelProperty("反馈标题")
    private String feedbackTitle;

    @ApiModelProperty("问题url")
    private String problemUrl;

    @ApiModelProperty("附件")
    private String fileCodes;

    @ApiModelProperty("反馈状态")
    private String feedbackStatus;
    private String feedbackStatusDesc;

    @ApiModelProperty("关闭理由")
    private String closeReason;

    @ApiModelProperty("关闭理由描述")
    private String closeReasonDesc;

    @ApiModelProperty("加急标识，0：不加急，1：加急")
    private Integer urgentFlag;

    @ApiModelProperty("回复状态")
    private String replyStatus;
    private String replyStatusDesc;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("问题类型")
    private String problemType;
    private String problemTypeDesc;

    @ApiModelProperty("所属功能")
    private Long functionId;

    @ApiModelProperty("所属功能描述")
    private String functionIdDesc;


    @ApiModelProperty("负责人")
    private Long directorUserId;

    @ApiModelProperty("负责人名称")
    private String directorUserIdDesc;

    @ApiModelProperty("阅览量")
    private Long readAmount;

    @ApiModelProperty("标签")
    private String tags;

    @ApiModelProperty("常用问题标识")
    private Integer commonFlag;

    @ApiModelProperty("问题反馈处理过程")
    private List<PrdSystemProblemFeedbackProcessVO> processList;

    @ApiModelProperty("最近处理时间")
    private LocalDateTime lastProcessTime;

    @ApiModelProperty("回复时间")
    private LocalDateTime replyTime;

    @ApiModelProperty("未回复间隔")
    private Long noReplyTimeInterval;

    @ApiModelProperty("严重程度")
    private String level;

    @ApiModelProperty("严重程度描述")
    private String levelDesc;

    /**
     * 创建人名称
     */
    @ApiModelProperty("创建人名称")
    private String createUserName;
}
