package com.elitesland.tw.tw5.api.common;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * tw工作流通用返回
 *
 * @author duwh
 * @date 2023/03/29
 */
@Getter
@Setter
@ToString
public class TwWorkFlowCommonVO extends BaseViewModel implements Serializable {

    /** 流程信息 */
    @ApiModelProperty("流程信息")
    private TaskInfo taskInfo;

    /** 流程实例ID */
    @ApiModelProperty("流程实例ID")
    private String procInstId;
    /** 流程审批状态 */
    @ApiModelProperty("流程审批状态")
    private ProcInstStatus procInstStatus;
    /** 提交时间 */
    @ApiModelProperty("提交时间")
    private LocalDateTime submitTime;
    /** 审批时间 */
    @ApiModelProperty("审批时间")
    private LocalDateTime approvedTime;

}
