package com.elitesland.tw.tw5.api.demo.student.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.demo.student.payload.DemoStudentPayload;
import com.elitesland.tw.tw5.api.demo.student.query.DemoStudentQuery;
import com.elitesland.tw.tw5.api.demo.student.vo.DemoStudentVO;

import java.util.List;

/**
 * 学生 service
 *
 * @author zhangyongqiang
 */
public interface DemoStudentService {

    /**
     * 新增
     *
     * @param payload 单据数据
     */
    DemoStudentVO insert(DemoStudentPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     */
    DemoStudentPayload update(DemoStudentPayload payload);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return vo对象
     */
    DemoStudentVO queryByKey(Long key);

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    PagingVO<DemoStudentVO> paging(DemoStudentQuery query);

    /**
     * 列表查询
     *
     * @param query 查询参数
     * @return 结果列表
     */
    List<DemoStudentVO> queryList(DemoStudentQuery query);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);
}
