package com.elitesland.tw.tw5.api.prd.crm.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationSitesPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationSitesQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationSitesVO;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
* 客户经营-企业年报网址
*
* @author duwh
* @date 2022-12-05
*/
public interface CrmCustomerOperationSitesService {

    /**
    * 分页列表
    *
    * @param query 条件
    * @return {@link PagingVO}<{@link CrmCustomerOperationSitesVO}>
    */
    PagingVO<CrmCustomerOperationSitesVO> paging(CrmCustomerOperationSitesQuery query);

    /**
    * 查询列表
    *
    * @param query 条件参数
    * @return {@link List}<{@link CrmCustomerOperationSitesVO}>
    */
    List<CrmCustomerOperationSitesVO> queryList(CrmCustomerOperationSitesQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link CrmCustomerOperationSitesVO}
     */
    CrmCustomerOperationSitesVO queryByKey(Long key);

    /**
    * 新增
    *
    * @param payload 单据数据
    * @return {@link CrmCustomerOperationSitesVO}
    */
    CrmCustomerOperationSitesVO insert(CrmCustomerOperationSitesPayload payload);

    /**
    * 修改
    *
    * @param payload 单据数据
    * @return {@link CrmCustomerOperationSitesVO}
    */
    CrmCustomerOperationSitesVO update(CrmCustomerOperationSitesPayload payload);

    /**
    * 逻辑删除
    *
    * @param keys 主键集合
    */
    void deleteSoft(List<Long> keys);

    /**
    * Excel导出数据
    *
    * @param all 待导出的数据
    * @param response /
    * @throws IOException /
    */
    void download(List<CrmCustomerOperationSitesVO> all, HttpServletResponse response) throws IOException;
}
