package com.elitesland.tw.tw5.api.prd.crm.service;


import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityOutCostPayload;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityOutCostVO;

import java.util.List;


/**
 * @author carl.wang
 * @Description:商机外包费用管理
 */
public interface CrmOpportunityOutCostService {

    /**
     * @param payload
     * @Description 新增
     **/
    CrmOpportunityOutCostVO insert(CrmOpportunityOutCostPayload payload);

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link Long}
     * @Description 修改
     */
    Long update(CrmOpportunityOutCostPayload payload);

    /**
     * 查询通过id
     *
     * @param id id
     * @return {@link CrmOpportunityOutCostVO}
     */
    CrmOpportunityOutCostVO queryById(Long id);

    /**
     * @param oppoId 商机id
     * @return
     * @Description 列表查询
     **/
    List<CrmOpportunityOutCostVO> queryList(Long oppoId);


    /**
     * @param keys   主键
     * @param oppoId 商机id
     * @Description 删除
     **/
    boolean deleteSoft(Long oppoId, List<Long> keys);

    /**
     * 提交
     *
     * @param id id
     */
    void submit(Long id);
}

